/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generating Json for output blocks.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Json.outputs');

goog.require('Blockly.Json');








Blockly.Json['outputs_closeall'] = function (block) {
  var value_channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
  // TODO: Assemble Json into code variable.
  var code = '{"Id":' + block.id + ',"Category":"outputs","Command":"outputs-closeall"}';
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['outputs_openall'] = function (block) {
  var value_channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
  // TODO: Assemble Json into code variable.
  var code = '{"Id":' + block.id + ',"Command":"outputs-openall"}';
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};







Blockly.Json['output_state'] = function (block) {
  var channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
  channel = channel.replaceAll('"', '');

  var state = block.getFieldValue('STATE');

  var codeJson = { Type: 'RelayControl', Method: 'SetState', Params: { Channel: channel, State: state } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['output_pulse'] = function (block) {
  var channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
  channel = channel.replaceAll('"', '');

  var state = block.getFieldValue('STATE');
  var duration = Blockly.Json.valueToCode(block, 'DURATION', Blockly.Json.ORDER_ATOMIC);

  var codeJson = { Type: 'RelayControl', Method: 'PulseRelay', Params: { Channel: channel, State: state, Duration: duration } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['outputs_open'] = function (block) {
  var channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
  channel = channel.replaceAll('"', '');

  var codeJson = { Type: 'RelayControl', Method: 'OpenRelay', Params: { Channel: channel } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['outputs_close'] = function (block) {
  var channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
  channel = channel.replaceAll('"', '');

  var codeJson = { Type: 'RelayControl', Method: 'CloseRelay', Params: { Channel: channel } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['outputs_setblock'] = function (block) {
  var stateMask = Blockly.Json.valueToCode(block, 'STATE_MASK', Blockly.Json.ORDER_ATOMIC);
  var channelMask = Blockly.Json.valueToCode(block, 'CHANNEL_MASK', Blockly.Json.ORDER_ATOMIC);

  var codeJson = { Type: 'RelayControl', Method: 'SetBlock', Params: { StateMask: stateMask, ChannelMask: channelMask } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['outputs_pulseblock'] = function (block) {
  var stateMask = Blockly.Json.valueToCode(block, 'STATE_MASK', Blockly.Json.ORDER_ATOMIC);
  var channelMask = Blockly.Json.valueToCode(block, 'CHANNEL_MASK', Blockly.Json.ORDER_ATOMIC);
  var duration = Blockly.Json.valueToCode(block, 'DURATION', Blockly.Json.ORDER_ATOMIC);

  var codeJson = { Type: 'RelayControl', Method: 'PulseBlock', Params: { StateMask: stateMask, ChannelMask: channelMask, Duration: duration } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['external_set_10v'] = function (block) {
  var channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
  var type = block.getFieldValue('TYPE');
  var value = Blockly.Json.valueToCode(block, 'VALUE', Blockly.Json.ORDER_ATOMIC);

  var codeJson = {
    Type: 'ExternalControl', Method: 'Set10v', Params: {
      Channel: channel, Type: type, Value: value
    }
  };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['external_set_420ma'] = function (block) {
  var channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
  var type = block.getFieldValue('TYPE');
  var value = Blockly.Json.valueToCode(block, 'VALUE', Blockly.Json.ORDER_ATOMIC);

  var codeJson = {
    Type: 'ExternalControl', Method: 'Set420ma', Params: {
      Channel: channel, Type: type, Value: value
    }
  };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


// Blockly.JavaScript['external_set_10v'] = function (block) {
//   var channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
//   var type = block.getFieldValue('TYPE');
//   var value = Blockly.Json.valueToCode(block, 'VALUE', Blockly.Json.ORDER_ATOMIC);

//   var codeJson = { Type: 'ExternalControl', Method: 'Set10v', Params: { Channel: channel, Type: type, Value: value } };
//   var code = JSON.stringify(codeJson);
//   if (block.nextConnection.targetConnection != null) code += ',\n';
//   return code;
// };