/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.triggers;

import com.integ.janoslib.iolog.IoLogListener;
import com.integ.snap.actions.Action;
import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.Scope;
import com.integ.snap.ast.ASTIdentifier;
import com.integ.snap.triggers.Trigger;
import com.integ.snap.triggers.TriggerCollection;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.threading.ThreadPool;
import com.integpg.system.IoEvent;
import java.util.Json;

public class InternalIoMonitorTrigger
extends Trigger
implements IoLogListener {
    private Action[] _triggerActions;
    private String _type;
    private int _channel;
    private int _channelMask;
    private String _state;
    private Queue<ASTIdentifier> _usedTriggerIdentifiers = new Queue();
    private boolean _reset = true;

    public InternalIoMonitorTrigger(Scope parent, Json json) {
        super(parent, json);
        try {
            this._type = this._paramsJson.getString("Type");
        }
        catch (Exception ex) {
            AppLog.error("error getting IO Type", ex);
        }
        try {
            this._channel = this._paramsJson.getInt("Channel");
            this._channelMask = 1 << this._channel - 1;
        }
        catch (Exception ex) {
            AppLog.error("error getting IO channel", ex);
        }
        try {
            this._state = this._paramsJson.getString("State");
        }
        catch (Exception ex) {
            AppLog.error("error getting trigger state", ex);
        }
        try {
            Json[] actions = (Json[])this._paramsJson.get("TriggerActions");
            this._triggerActions = new Action[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                Json actionJson = actions[i];
                try {
                    this._triggerActions[i] = ActionFactory.getActionClass(parent, actionJson);
                    continue;
                }
                catch (Exception ex) {
                    AppLog.error("error getting action", ex);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("error getting IO Type", ex);
        }
    }

    public String getType() {
        return this._type;
    }

    @Override
    public void evaluate() throws Throwable {
        throw new Exception("This class should be called by the io log monitor");
    }

    @Override
    public void onIoEvent(IoEvent ioEvent) {
        System.out.println("io event disabled: " + this._disabled);
        if (!this._disabled) {
            this.processTrigger(ioEvent);
        }
    }

    @Override
    public void onIoEventsProcessed() {
    }

    private void processTrigger(IoEvent ioEvent) {
        try {
            boolean channelAffected;
            boolean bl = channelAffected = this._channelMask == (ioEvent.mask & this._channelMask);
            if (channelAffected) {
                boolean triggered = "EITHER".equalsIgnoreCase(this._state);
                if (!triggered) {
                    boolean state = this._channelMask == (ioEvent.states & this._channelMask);
                    boolean bl2 = triggered = "HIGH".equalsIgnoreCase(this._state) && state || "LOW".equalsIgnoreCase(this._state) && !state;
                }
                if (triggered) {
                    ThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            for (Action action : InternalIoMonitorTrigger.this._triggerActions) {
                                try {
                                    action.execute();
                                }
                                catch (Throwable ex) {
                                    Throwable throwable = new RuntimeException("error executing trigger actions for " + InternalIoMonitorTrigger.this.getName() + " monitor trigger").initCause(ex);
                                    AppLog.error(throwable);
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable ex) {
            AppLog.error("error evaluating monitor loop", ex);
        }
    }

    public void finalize() {
        TriggerCollection.removeTrigger(this);
    }
}

