/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.network;

import com.integ.janoslib.net.TCPConnection;
import com.integ.snap.actions.Action;
import com.integ.snap.actions.Scope;
import com.integ.snap.devices.TcpDeviceCollection;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.net.BytesReceivedEvent;
import com.integpg.janoslib.net.TcpConnectionListener;
import com.integpg.janoslib.utils.HexUtils;
import java.util.EventObject;
import java.util.Json;

public class TcpDeviceSetMethod
extends Action
implements TcpConnectionListener {
    private final String _host;
    private final int _port;
    private final Action[] _onConnectActions;
    private final Action[] _onDisconnectActions;

    public TcpDeviceSetMethod(Scope parent, Json json) {
        super(parent, json);
        this._host = this._paramsJson.getString("Host");
        this._port = this.getIntParam("Port");
        this._onConnectActions = this.getActions("OnConnect");
        this._onDisconnectActions = this.getActions("OnDisconnect");
        System.out.println(String.format("Name: %s, Host: %s, Port: %d", this._name, this._host, this._port));
        try {
            TcpDeviceCollection.addTcpDevice(this);
            TCPConnection _tcpConnection = new TCPConnection();
            _tcpConnection.setHostInformation(this._host, this._port);
            _tcpConnection.addConnectionListener(this);
            _tcpConnection.connect();
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
    }

    @Override
    public void execute() throws Throwable {
        throw new UnsupportedOperationException("Set method class.  should not be executed..");
    }

    @Override
    public void connectionAttempt(EventObject evt) {
        TCPConnection connection = (TCPConnection)evt.getSource();
        AppLog.info(String.format("Attempting connection to %s", connection.getConnectionInfo()));
    }

    @Override
    public void connectionEstablished(EventObject evt) {
        TCPConnection connection = (TCPConnection)evt.getSource();
        AppLog.info(String.format("Connection established to %s", connection.getConnectionInfo()));
        try {
            for (Action action : this._onConnectActions) {
                action.execute();
            }
        }
        catch (Throwable ex) {
            AppLog.error("error executing on connect actions", ex);
        }
    }

    @Override
    public void connectionClosed(EventObject evt) {
        TCPConnection connection = (TCPConnection)evt.getSource();
        AppLog.info(String.format("Connection lost from %s", connection.getConnectionInfo()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Action action : TcpDeviceSetMethod.this._onDisconnectActions) {
                        action.execute();
                    }
                }
                catch (Throwable ex) {
                    AppLog.error("error executing on connect actions", ex);
                }
            }
        }).start();
    }

    @Override
    public void bytesReceived(BytesReceivedEvent evt) {
        try {
            AppLog.info(String.format("--> %s: recv'd %d bytes: %s", this._name, evt.getLength(), HexUtils.hexDump(evt.getBytes(), evt.getOffset(), evt.getLength())));
        }
        catch (Exception ex) {
            AppLog.error("error processing read bytes", ex);
        }
    }
}

