/**
 * @license
 * Visual Blocks Editor
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Colour blocks for Blockly.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Blocks.ethernet');

goog.require('Blockly.Blocks');


Blockly.Blocks.ethernet.HUE = 180;

Blockly.Blocks['ethernet_tcp_send'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("TCP Send");
        this.appendValueInput("IP_ADDRESS")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("IP Address:");
        this.appendValueInput("PORT")
            .setCheck("Number")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Port:");
        this.appendValueInput("DATA")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Data:");
        this.setInputsInline(false);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(Blockly.Blocks.ethernet.HUE);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};


Blockly.Blocks['ethernet_udp_send'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("UDP Send");
        this.appendValueInput("IP_ADDRESS")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("IP Address:");
        this.appendValueInput("PORT")
            .setCheck("Number")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Port:");
        this.appendValueInput("DATA")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Data:");
        this.setInputsInline(false);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(Blockly.Blocks.ethernet.HUE);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};


Blockly.Blocks['communication_send_email_profile'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Send Email Profile");
        this.appendValueInput("EMAIL_PROFILE")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Email Profile:");
        this.setInputsInline(true);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(Blockly.Blocks.ethernet.HUE);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};


Blockly.Blocks['communication_send_email'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Send Email");
        this.appendValueInput("TO_ADDRESSES")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("To Addresses:");
        this.appendValueInput("SUBJECT")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Subject:");
        this.appendValueInput("MESSAGE")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Message:");
        this.setInputsInline(false);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(Blockly.Blocks.ethernet.HUE);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};


Blockly.Blocks['ethernet_mqtt_publish'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("MQTT Publish");
        this.appendValueInput("MQTT_NAME")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Broker Name:");
        this.appendValueInput("DATA")
            .setCheck("String")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Data:");
        this.setInputsInline(false);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(Blockly.Blocks.ethernet.HUE);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};