/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.ast;

import com.integ.snap.ast.ASTIdentifier;
import com.integ.snap.ast.identifierobjects.IdentifierObject;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ASTDeviceIdentifier
extends ASTIdentifier {
    protected static final Pattern DEVICE_PATTERN = Pattern.compile("([\\w_])+\\[(\\d+)\\]\\.([\\w_]+)");
    private String _deviceString;
    private int _channel;
    private String _fieldName;
    public IdentifierObject _identifierObject;

    protected ASTDeviceIdentifier(String identifierString) {
        super(identifierString);
        long start = System.currentTimeMillis();
        Matcher matcher = DEVICE_PATTERN.matcher(identifierString);
        boolean found = matcher.find();
        if (found) {
            this._deviceString = matcher.group(1);
            this._channel = Integer.valueOf(matcher.group(2));
            this._fieldName = matcher.group(3);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("ASTDeviceIdentifier elapsed: " + elapsed);
        start = System.currentTimeMillis();
        try {
            Queue<Token> tokenQueue = new Queue<Token>();
            Lexer.parse(tokenQueue, identifierString);
            TokenStream tokens = new TokenStream(tokenQueue);
            Token currentToken = tokens.getCurrent();
            if (0 != currentToken.type) {
                throw new RuntimeException("device identifier expected.  found " + currentToken + " instead");
            }
            String identifierNameString = currentToken.content;
            this._identifierObject = IdentifierObject.getIdentifierObject(identifierNameString);
            if (null == this._identifierObject) {
                throw new RuntimeException("unknown identifier object for " + identifierNameString);
            }
            currentToken = tokens.nextToken();
            if (91 == currentToken.type) {
                currentToken = tokens.nextToken();
                if (3 != currentToken.type) {
                    throw new RuntimeException("channel expected.  found " + currentToken + " instead");
                }
                int channel = Integer.parseInt(currentToken.content);
                this._identifierObject.setChannel(channel);
                currentToken = tokens.nextToken();
                if (93 != currentToken.type) {
                    throw new RuntimeException("']' expected.  found " + currentToken + " instead");
                }
            }
            currentToken = tokens.nextToken();
            if (46 != currentToken.type) {
                throw new RuntimeException("'.' expected.  found " + currentToken + " instead");
            }
            currentToken = tokens.nextToken();
            String fieldOrMethod = currentToken.content;
            if (!tokens.isEmpty()) {
                currentToken = tokens.nextToken();
                if (40 == currentToken.type) {
                    System.out.println("parens: " + currentToken);
                    String params = identifierString.substring(currentToken.colPos + 1);
                    System.out.println("params: " + params);
                    this._identifierObject.setMethod(fieldOrMethod, params);
                }
            } else {
                this._identifierObject.setField(fieldOrMethod);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        elapsed = System.currentTimeMillis() - start;
        System.out.println("ASTDeviceIdentifier elapsed2: " + elapsed);
        if (null != this._identifierObject) {
            System.out.println("identifierObject.evaluate(): " + this._identifierObject.evaluate());
        }
    }

    public String getDeviceString() {
        return this._deviceString;
    }

    public int getChannel() {
        return this._channel;
    }

    public String getFieldName() {
        return this._fieldName;
    }
}

