/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net;

import com.integ.janoslib.net.TCPConnectionListenerNotifier;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.logger.SystemOutLog;
import com.integpg.janoslib.net.BytesReceivedEvent;
import com.integpg.janoslib.net.TcpConnectionListener;
import com.integpg.janoslib.utils.HexUtils;
import java.io.IOException;
import java.net.Socket;
import java.util.EventObject;

public class TCPConnection
implements Runnable {
    private Logger _log = new SystemOutLog();
    private Socket _client = null;
    private String _host = "0.0.0.0";
    private int _port;
    private String _connectionInfomationString = null;
    private Thread _thread = null;
    private final TCPConnectionListenerNotifier _connectionListenerNotifier = new TCPConnectionListenerNotifier();

    public TCPConnection setLog(Logger log) {
        this._log = log;
        return this;
    }

    public TCPConnection setHostInformation(String host, int port) {
        this._host = host;
        this._port = port;
        this._connectionInfomationString = String.format("%s:%d", this._host, this._port);
        return this;
    }

    public String getConnectionInfo() {
        return this._connectionInfomationString;
    }

    public void addConnectionListener(TcpConnectionListener listener) {
        this._connectionListenerNotifier.addConnectionListener(listener);
    }

    public synchronized void connect() throws Exception {
        try {
            this._connectionListenerNotifier.notifyConnectionAttempt(new EventObject(this));
            this._log.info(String.format("connect to %s:%d", this._host, this._port));
            if ("0.0.0.0".equals(this._host)) {
                return;
            }
            this._client = new Socket(this._host, this._port);
            this._connectionInfomationString = String.format("%s:%d using local %d", this._host, this._client.getPort(), this._client.getLocalPort());
            this._log.info(String.format("connected to %s", this._connectionInfomationString));
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName());
            this._thread.setDaemon(true);
            this._thread.start();
            this._connectionListenerNotifier.notifyConnectionEstablished(new EventObject(this));
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean graceful) {
        try {
            if (null != this._client) {
                this._log.info(String.format("closing connection to %s", this._connectionInfomationString));
                this._client.close();
                this._connectionListenerNotifier.notifyConnectionClosed(new EventObject(this));
            }
        }
        catch (IOException ex) {
            this._log.error("error closing socket", ex);
        }
        finally {
            this._client = null;
        }
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        try {
            while (null != this._client) {
                int bytesRead = this._client.getInputStream().read(buffer);
                if (-1 == bytesRead) {
                    throw new IOException();
                }
                this._connectionListenerNotifier.notifyBytesReceived(new BytesReceivedEvent(this, buffer, 0, bytesRead));
            }
        }
        catch (Exception ex) {
            this.close();
            this._log.error("error in run()", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] bytes) {
        block6: {
            try {
                if (null == this._client) {
                    this.connect();
                }
                if (null == this._client) break block6;
                Socket socket = this._client;
                synchronized (socket) {
                    this._client.getOutputStream().write(bytes);
                    this._client.getOutputStream().flush();
                }
            }
            catch (Exception ex) {
                this._log.error(String.format("error sending: %s" + HexUtils.bytesToHex(bytes), new Object[0]), ex);
                this.close(false);
            }
        }
    }
}

