/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.logical;

import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.BooleanResultAction;
import com.integ.snap.actions.Scope;
import com.integpg.janoslib.io.AppLog;
import java.util.Json;

public class LogicalOperation
extends BooleanResultAction {
    private final String _operationString;
    private BooleanResultAction _aAction;
    private BooleanResultAction _bAction;

    public LogicalOperation(Scope parent, Json json) {
        super(parent, json);
        try {
            Json aJson = (Json)this._paramsJson.get("A");
            this._aAction = (BooleanResultAction)ActionFactory.getActionClass(parent, aJson);
        }
        catch (Exception ex) {
            AppLog.error("error getting Logical Operation for A", ex);
        }
        this._operationString = this._paramsJson.getString("Operator");
        try {
            Json bJson = (Json)this._paramsJson.get("B");
            this._bAction = (BooleanResultAction)ActionFactory.getActionClass(parent, bJson);
        }
        catch (Exception ex) {
            AppLog.error("error getting Logical Operation for B", ex);
        }
    }

    @Override
    public String getExpression() {
        return this._aAction.getExpression() + " " + this._operationString + " " + this._bAction.getExpression();
    }

    @Override
    public boolean getResult() throws Throwable {
        boolean aResult = this._aAction.getResult();
        boolean bResult = this._bAction.getResult();
        if ("&&".equals(this._operationString)) {
            return aResult && bResult;
        }
        if ("||".equals(this._operationString)) {
            return aResult || bResult;
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

