/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.triggers;

import com.integ.snap.actions.Scope;
import com.integ.snap.triggers.InternalIoMonitorTrigger;
import com.integ.snap.triggers.IntervalTrigger;
import com.integ.snap.triggers.MonitorTrigger;
import com.integ.snap.triggers.ScheduleAtMethod;
import com.integ.snap.triggers.Trigger;
import com.integ.snap.triggers.TriggerCollection;
import java.util.Json;

public class TriggerFactory {
    public static Trigger getTriggerMethod(Scope parent, Json json) throws Exception {
        String methodString = json.getString("Method");
        Trigger trigger = null;
        switch (methodString) {
            case "MonitorTrigger": {
                trigger = new MonitorTrigger(parent, json);
                break;
            }
            case "InternalIoTrigger": {
                trigger = new InternalIoMonitorTrigger(parent, json);
                break;
            }
            case "ScheduleAt": {
                trigger = new ScheduleAtMethod(parent, json);
                break;
            }
            case "Every": {
                trigger = new IntervalTrigger(parent, json);
                break;
            }
            default: {
                throw new Exception("Unknown trigger method: " + methodString);
            }
        }
        if (null != trigger) {
            TriggerCollection.addTrigger(trigger);
        }
        return trigger;
    }
}

