/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.network;

import com.integ.snap.actions.Action;
import com.integ.snap.actions.Scope;
import com.integ.snap.actions.filesystem.Identifier;
import com.integpg.system.JANOS;
import com.integpg.system.MailComposer;
import java.util.Json;

public class EmailProfileSendMethod
extends Action {
    private final String _emailProfileName;

    public EmailProfileSendMethod(Scope parent, Json json) {
        super(parent, json);
        this._emailProfileName = this._paramsJson.getString("EmailProfile").trim();
    }

    @Override
    public void execute() throws Throwable {
        try {
            System.out.println("EmailProfile command: " + this._emailProfileName);
            String[] toAddresses = JANOS.getRegistryKey((String)("Email/" + this._emailProfileName + "/ToAddress"));
            String[] toCcAddresses = JANOS.getRegistryKey((String)("Email/" + this._emailProfileName + "/CcAddress"));
            String[] toBccAddresses = JANOS.getRegistryKey((String)("Email/" + this._emailProfileName + "/BccAddress"));
            String subject = JANOS.getRegistryString((String)("Email/" + this._emailProfileName + "/Subject"), (String)"");
            System.out.println("subject: " + subject);
            subject = this.replace(subject);
            System.out.println("subject: " + subject);
            String message = JANOS.getRegistryString((String)("Email/" + this._emailProfileName + "/Message"), (String)"");
            System.out.println("message: " + message);
            message = this.replace(message);
            System.out.println("message: " + message);
            MailComposer mailComposer = new MailComposer();
            mailComposer.setToAddress(toAddresses);
            mailComposer.setCcAddress(toCcAddresses);
            mailComposer.setBccAddress(toBccAddresses);
            mailComposer.setSubject(subject);
            mailComposer.setMessage(message);
            mailComposer.send();
        }
        catch (Exception ex) {
            throw new Exception("Error executing Email Profile Send").initCause(ex);
        }
    }

    private String replace(String text) {
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        while (text.length() > lastIndex) {
            int doubleLeftBracketPos = text.indexOf("{{", lastIndex);
            if (-1 == doubleLeftBracketPos) {
                sb.append(text.substring(lastIndex));
                lastIndex = text.length();
                continue;
            }
            int doubleRightBracketPos = text.indexOf("}}", doubleLeftBracketPos);
            if (-1 == doubleRightBracketPos) {
                sb.append(text.substring(lastIndex));
                lastIndex = text.length();
                continue;
            }
            if (doubleLeftBracketPos != lastIndex) {
                sb.append(text.substring(lastIndex, doubleLeftBracketPos));
            }
            String bindObjectString = text.substring(doubleLeftBracketPos + 2, doubleRightBracketPos);
            Identifier identifier = new Identifier(bindObjectString);
            String newValue = identifier.evaluate().toString();
            System.out.println("newValue: " + newValue);
            sb.append(newValue);
            lastIndex = doubleRightBracketPos + 2;
        }
        return sb.toString();
    }
}

