/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.network;

import com.integ.snap.actions.Action;
import com.integ.snap.actions.Scope;
import com.integ.snap.actions.filesystem.Identifier;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.MailComposer;
import java.util.Json;

public class EmailSendMethod
extends Action {
    private final String _toAddresses;
    private final String _subject;
    private final String _message;

    public EmailSendMethod(Scope parent, Json json) {
        super(parent, json);
        this._toAddresses = StringUtils.trim(this._paramsJson.getString("ToAddresses"), ' ');
        this._subject = StringUtils.trim(this._paramsJson.getString("Subject"), ' ');
        this._message = StringUtils.trim(this._paramsJson.getString("Message"), ' ');
    }

    @Override
    public void execute() throws Throwable {
        try {
            System.out.println("EmailSend command");
            String subject = this._subject;
            System.out.println("subject: " + subject);
            subject = this.replace(subject);
            System.out.println("subject: " + subject);
            String message = this._message;
            System.out.println("message: " + message);
            message = this.replace(message);
            System.out.println("message: " + message);
            byte[] messageBytes = StringUtils.getEscapedBytes(message);
            MailComposer mailComposer = new MailComposer();
            mailComposer.setToAddress(this._toAddresses);
            mailComposer.setSubject(subject);
            mailComposer.setMessage(new String(messageBytes));
            mailComposer.send();
        }
        catch (Exception ex) {
            throw new Exception("Error executing Email Send").initCause(ex);
        }
    }

    private String replace(String text) {
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        while (text.length() > lastIndex) {
            String bindObjectString;
            Identifier identifier;
            Object newValue;
            int doubleLeftBracketPos = text.indexOf("{{", lastIndex);
            if (-1 == doubleLeftBracketPos) {
                sb.append(text.substring(lastIndex));
                lastIndex = text.length();
                continue;
            }
            int doubleRightBracketPos = text.indexOf("}}", doubleLeftBracketPos);
            if (-1 == doubleRightBracketPos) {
                sb.append(text.substring(lastIndex));
                lastIndex = text.length();
                continue;
            }
            if (doubleLeftBracketPos != lastIndex) {
                sb.append(text.substring(lastIndex, doubleLeftBracketPos));
            }
            if (null != (newValue = (identifier = new Identifier(bindObjectString = text.substring(doubleLeftBracketPos + 2, doubleRightBracketPos))).evaluate())) {
                String newValueString = newValue.toString();
                System.out.println("newValue: " + newValue);
                sb.append(newValue);
            } else {
                sb.append("--");
            }
            lastIndex = doubleRightBracketPos + 2;
        }
        return sb.toString();
    }
}

