/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.ast;

import com.integ.snap.ast.ASTNode;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.lexer.Token;

public class ASTLogicalNode
implements ASTNode {
    private final Token _operator;
    private final ASTNode _left;
    private final ASTNode _right;

    public ASTLogicalNode(Token operator, ASTNode left, ASTNode right) {
        this._operator = operator;
        this._left = left;
        this._right = right;
    }

    @Override
    public Boolean evaluate() {
        Object left = this._left.evaluate();
        if (DEBUG.ON) {
            System.out.println("logical left: " + left + " " + left.getClass());
        }
        Object right = this._right.evaluate();
        if (DEBUG.ON) {
            System.out.println("logical right: " + right + " " + right.getClass());
        }
        boolean result = false;
        switch (this._operator.type) {
            case 11: {
                if (left instanceof Boolean && right instanceof Boolean) {
                    result = left == right;
                    break;
                }
                double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                result = l == r;
                break;
            }
            case 12: {
                if (left instanceof Boolean && right instanceof Boolean) {
                    result = left != right;
                    break;
                }
                double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                result = l != r;
                break;
            }
            case 10: {
                boolean l;
                boolean bl = left instanceof Boolean ? (Boolean)left : (l = 0.0 != (left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left));
                boolean r = right instanceof Boolean ? (Boolean)right : 0.0 != (right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right);
                result = l && r;
                break;
            }
            case 9: {
                boolean l;
                boolean bl = left instanceof Boolean ? (Boolean)left : (l = 0.0 != (left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left));
                boolean r = right instanceof Boolean ? (Boolean)right : 0.0 != (right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right);
                result = l || r;
                break;
            }
            case 94: {
                boolean l;
                boolean bl = left instanceof Boolean ? (Boolean)left : (l = 0.0 != (left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left));
                boolean r = right instanceof Boolean ? (Boolean)right : 0.0 != (right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right);
                result = l ^ r;
                break;
            }
            case 60: {
                double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                result = l < r;
                break;
            }
            case 14: {
                double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                result = l <= r;
                break;
            }
            case 62: {
                double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                result = l > r;
                break;
            }
            case 13: {
                double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                result = l >= r;
                break;
            }
        }
        if (DEBUG.ON) {
            System.out.println("ASTLogicalNode: " + this + " = " + result);
        }
        return result;
    }

    public String toString() {
        String retString = "(";
        retString = retString + this._left;
        retString = retString + " " + this._operator.content + " ";
        retString = retString + this._right;
        retString = retString + ")";
        return retString;
    }
}

