/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.network;

import com.integ.snap.actions.Action;
import com.integ.snap.actions.Scope;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.janoslib.utils.StringUtils;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Json;

public class UdpSendMethod
extends Action {
    private final String _host;
    private final int _port;
    private final String _data;

    public UdpSendMethod(Scope parent, Json json) {
        super(parent, json);
        this._host = StringUtils.trim(this._paramsJson.getString("IpAddress"), ' ');
        this._port = Integer.parseInt(StringUtils.trim(this._paramsJson.getString("Port"), ' '));
        this._data = StringUtils.trim(this._paramsJson.getString("Data"), ' ');
    }

    @Override
    public void execute() throws Throwable {
        System.out.println("execute Network.TcpSend: Send " + this._data + " to " + this._host + ":" + this._port);
        DatagramSocket datagramSocket = new DatagramSocket();
        try {
            byte[] dataBytes = StringUtils.getEscapedBytes(this._data);
            System.out.println(HexUtils.hexDump(dataBytes));
            InetAddress address = InetAddress.getByName(this._host);
            DatagramPacket dp = new DatagramPacket(dataBytes, dataBytes.length, address, this._port);
            datagramSocket.send(dp);
        }
        catch (Exception ex) {
            throw new Exception("Error executing UDP Send").initCause(ex);
        }
        finally {
            if (null != datagramSocket) {
                datagramSocket.close();
            }
        }
    }
}

