/*
 * Decompiled with CFR 0.152.
 */
package com.integ.taskerjson;

import com.integ.janoslib.messagepump.MessagePumpAppHandler;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.taskerjson.AssemblyInfo;
import com.integ.taskerjson.Config;
import com.integ.taskerjson.MqttInterface;
import com.integ.taskerjson.MqttPublishSystemMessage;
import com.integ.taskerjson.MqttSystemMessage;
import com.integ.taskerjson.SnapAsciiCommandSerialClient;
import com.integ.taskerjson.SnapAsciiCommandServer;
import com.integ.taskerjson.SnapsCollection;
import com.integ.taskerjson.messagehandlers.ExecuteScriptEventHandler;
import com.integ.taskerjson.messagehandlers.GetStacksEventHandler;
import com.integ.taskerjson.messagehandlers.ScriptUpdatedEventHandler;
import com.integ.taskerjson.messagehandlers.devices.GetDevicesEventHandler;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.system.JANOS;
import java.io.IOException;

public class SnapMain {
    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        Application.init(new AssemblyInfo());
        Application.enableApplicationWatchdog(4);
        SnapMain main = new SnapMain();
        main.init();
        long elapsed = System.currentTimeMillis() - start;
        AppLog.info(String.format("application ready in %.3f seconds", (double)elapsed / 1000.0));
        Application.sleepForever();
    }

    public void init() throws IOException {
        AppLog.info("initialize");
        Config.init();
        AppLog.info("add web page listener");
        MessagePumpAppHandler snapAppListener = new MessagePumpAppHandler(1510).addCommandListener("stack.updated", new ScriptUpdatedEventHandler()).addCommandListener("stack.execute", new ExecuteScriptEventHandler()).addCommandListener("stacks.get", new GetStacksEventHandler()).addCommandListener("devices.get", new GetDevicesEventHandler());
        MessagePumpEngine.addListener(snapAppListener);
        MqttInterface mqttInterface = new MqttInterface();
        MessagePumpEngine.addListener(mqttInterface);
        AppLog.info("start message pump engine");
        MessagePumpEngine.start();
        SnapsCollection snapsCollection = new SnapsCollection(Config.SNAPS_DIRECTORY);
        snapsCollection.loadFiles();
        SnapAsciiCommandServer _asciiProtocl = new SnapAsciiCommandServer();
        _asciiProtocl.start();
        SnapAsciiCommandSerialClient.init();
        MqttSystemMessage msg = new MqttSystemMessage("get-status");
        MessagePumpEngine.postMessage(msg.getSystemMsg());
        msg = new MqttPublishSystemMessage("jnior/" + JANOS.getSerialNumber() + "/status/taskerjson", "started");
        MessagePumpEngine.postMessage(msg.getSystemMsg());
    }
}

