/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.triggers;

import com.integ.snap.actions.Action;
import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.Scope;
import com.integ.snap.triggers.TimeTrigger;
import com.integpg.janoslib.utils.DateUtils;
import java.util.Json;

public class ScheduleAtMethod
extends TimeTrigger {
    private final String _timeOfDayString;
    private long _timeOfDay;
    private final Action[] _triggerActions;
    private long _lastInspectionTime = Long.MAX_VALUE;

    public ScheduleAtMethod(Scope parent, Json json) {
        super(parent, json);
        this._timeOfDayString = this._paramsJson.getString("TimeOfDay");
        if (null != this._timeOfDayString) {
            long timeInDay = DateUtils.getTimeInDayFromString(this._timeOfDayString);
            long startOfDay = DateUtils.getStartOfDay();
            this._timeOfDay = startOfDay + timeInDay;
        }
        Json[] actions = (Json[])this._paramsJson.get("Statements");
        this._triggerActions = new Action[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            Json actionJson = actions[i];
            try {
                this._triggerActions[i] = ActionFactory.getActionClass(parent, actionJson);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void evaluate() throws Throwable {
        long now = System.currentTimeMillis();
        if (Long.MAX_VALUE == this._lastInspectionTime) {
            this._lastInspectionTime = now;
        }
        if (this._lastInspectionTime < this._timeOfDay && this._timeOfDay <= now) {
            TRIGGER_LOG.info(this.getName() + " process schedule at trigger");
            for (Action action : this._triggerActions) {
                System.out.println("execute action: " + action);
                action.execute();
            }
        }
        this._lastInspectionTime = now;
    }
}

