/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.filesystem;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.snap.actions.Action;
import com.integ.snap.actions.Scope;
import com.integ.snap.actions.filesystem.Identifier;
import com.integ.taskerjson.messagehandlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.janoslib.utils.StringUtils;
import java.io.File;
import java.util.Json;

public class LogMethod
extends Action {
    private static final QuickDateFormat DATE_FORMAT = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff zzz");
    private final String _filename;
    private final String _text;

    public LogMethod(Scope parent, Json json) {
        super(parent, json);
        this._filename = this._paramsJson.getString("Filename");
        this._text = this._paramsJson.getString("Text");
    }

    @Override
    public void execute() throws Throwable {
        try {
            String filename = this.replace(this._filename);
            System.out.println("filename: " + filename);
            File file = new File(filename);
            String parentPath = file.getParent();
            System.out.println("parentPath: " + parentPath);
            File parentFile = new File(parentPath);
            if (!parentFile.exists()) {
                System.out.println("create " + parentPath);
                parentFile.mkdir();
            }
            String text = this.replace(this._text);
            text = String.format("%s, %s", DATE_FORMAT.format(System.currentTimeMillis()), text);
            System.out.println("text: " + text);
            text = text + "\r\n";
            FileUtils.appendAllBytes(filename, StringUtils.getEscapedBytes(text));
        }
        catch (Exception ex) {
            Throwable throwable = new Exception(String.format("error in %s: %s", this.getClass().getName(), this._paramsJson.toString())).initCause(ex);
            ErrorMessage errorMessage = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(errorMessage.build());
            AppLog.error(throwable);
        }
    }

    private String replace(String text) {
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        while (text.length() > lastIndex) {
            String bindObjectString;
            Identifier identifier;
            Object newValue;
            int doubleLeftBracketPos = text.indexOf("{{", lastIndex);
            if (-1 == doubleLeftBracketPos) {
                sb.append(text.substring(lastIndex));
                lastIndex = text.length();
                continue;
            }
            int doubleRightBracketPos = text.indexOf("}}", doubleLeftBracketPos);
            if (-1 == doubleRightBracketPos) {
                sb.append(text.substring(lastIndex));
                lastIndex = text.length();
                continue;
            }
            if (doubleLeftBracketPos != lastIndex) {
                sb.append(text.substring(lastIndex, doubleLeftBracketPos));
            }
            if (null != (newValue = (identifier = new Identifier(bindObjectString = text.substring(doubleLeftBracketPos + 2, doubleRightBracketPos))).evaluate())) {
                String newValueString = newValue.toString();
                System.out.println("newValue: " + newValueString);
                sb.append(newValue);
            } else {
                sb.append("--");
            }
            lastIndex = doubleRightBracketPos + 2;
        }
        return sb.toString();
    }
}

