/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.triggers;

import com.integ.janoslib.iolog.IoLogMonitor;
import com.integ.snap.actions.Action;
import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.BooleanResultAction;
import com.integ.snap.actions.Scope;
import com.integ.snap.actions.logical.LogicalExpression;
import com.integ.snap.actions.logical.LogicalFactory;
import com.integ.snap.ast.ASTDeviceIdentifier;
import com.integ.snap.ast.ASTIdentifier;
import com.integ.snap.triggers.Trigger;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.threading.ThreadPool;
import java.util.Json;

public class MonitorTrigger
extends Trigger {
    private final Action[] _triggerActions;
    private BooleanResultAction _triggerConditionAction;
    private Queue<ASTIdentifier> _usedTriggerIdentifiers = new Queue();
    private Action[] _resetActions;
    private BooleanResultAction _resetConditionAction = null;
    private Queue<ASTIdentifier> _usedResetIdentifiers = new Queue();
    private boolean _reset = true;

    public MonitorTrigger(Scope parent, Json json) {
        super(parent, json);
        Json actionJson;
        try {
            Json triggerConditionJson = (Json)this._paramsJson.get("TriggerCondition");
            this._triggerConditionAction = LogicalFactory.getLogicalMethod(parent, triggerConditionJson);
            if (this._triggerConditionAction instanceof LogicalExpression) {
                LogicalExpression logicalExpression = (LogicalExpression)this._triggerConditionAction;
                this._usedTriggerIdentifiers = logicalExpression.getUsedIdentifiers();
            }
        }
        catch (Exception ex) {
            AppLog.error("error getting Trigger Condition", ex);
        }
        Json[] actions = (Json[])this._paramsJson.get("TriggerActions");
        this._triggerActions = new Action[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            actionJson = actions[i];
            try {
                this._triggerActions[i] = ActionFactory.getActionClass(parent, actionJson);
                continue;
            }
            catch (Exception ex) {
                AppLog.error("error getting action", ex);
            }
        }
        try {
            Json resetConditionJson;
            if (this._paramsJson.containsKey("ResetCondition") && null != (resetConditionJson = (Json)this._paramsJson.get("ResetCondition")) && !resetConditionJson.isEmpty()) {
                this._resetConditionAction = LogicalFactory.getLogicalMethod(parent, resetConditionJson);
                if (this._resetConditionAction instanceof LogicalExpression) {
                    LogicalExpression logicalExpression = (LogicalExpression)this._resetConditionAction;
                    this._usedResetIdentifiers = logicalExpression.getUsedIdentifiers();
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("error getting Reset Condition", ex);
        }
        actions = (Json[])this._paramsJson.get("ResetActions");
        if (null != actions) {
            this._resetActions = new Action[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                actionJson = actions[i];
                try {
                    this._resetActions[i] = ActionFactory.getActionClass(parent, actionJson);
                    continue;
                }
                catch (Exception ex) {
                    AppLog.error("error getting action", ex);
                }
            }
        }
    }

    @Override
    public void evaluate() throws Throwable {
        if (!this._disabled) {
            this.processTrigger();
        }
    }

    private void processTrigger() {
        if (!this._reset) {
            this.processReset();
            return;
        }
        try {
            boolean affectedIoPoint = false;
            if (this._triggerConditionAction instanceof LogicalExpression) {
                for (ASTIdentifier usedIidentifier : this._usedTriggerIdentifiers) {
                    int channel;
                    if (!(usedIidentifier instanceof ASTDeviceIdentifier)) continue;
                    ASTDeviceIdentifier usedDeviceIdentifier = (ASTDeviceIdentifier)usedIidentifier;
                    if (usedDeviceIdentifier.getDeviceString().equalsIgnoreCase("din")) {
                        if (null == IoLogMonitor.getLastInputEvent() || IoLogMonitor.getLastIoEvent() != IoLogMonitor.getLastInputEvent()) continue;
                        channel = usedDeviceIdentifier.getChannel();
                        affectedIoPoint |= (IoLogMonitor.getLastInputEvent().mask >> channel - 1 & 1) == 1;
                        continue;
                    }
                    if (usedDeviceIdentifier.getDeviceString().equalsIgnoreCase("rout")) {
                        if (null == IoLogMonitor.getLastOutputEvent() || IoLogMonitor.getLastIoEvent() != IoLogMonitor.getLastOutputEvent()) continue;
                        channel = usedDeviceIdentifier.getChannel();
                        affectedIoPoint |= (IoLogMonitor.getLastOutputEvent().mask >> channel - 1 & 1) == 1;
                        continue;
                    }
                    affectedIoPoint = true;
                }
            }
            if (affectedIoPoint) {
                boolean result = this._triggerConditionAction.getResult();
                if (DEBUG.ON) {
                    System.out.println(this._name + " monitor trigger result: " + result);
                }
                if (result) {
                    if (this._reset) {
                        TRIGGER_LOG.info(this.getName() + " process trigger");
                        this._reset = null == this._resetConditionAction;
                        ThreadPool.execute(new Runnable(){

                            @Override
                            public void run() {
                                for (Action action : MonitorTrigger.this._triggerActions) {
                                    try {
                                        action.execute();
                                    }
                                    catch (Throwable ex) {
                                        Throwable throwable = new RuntimeException("error executing trigger actions for " + MonitorTrigger.this.getName() + " monitor trigger").initCause(ex);
                                        AppLog.error(throwable);
                                    }
                                }
                            }
                        });
                    }
                } else {
                    this._reset = true;
                }
            }
        }
        catch (Throwable ex) {
            AppLog.error("error evaluating monitor loop", ex);
        }
    }

    private void processReset() {
        try {
            boolean affectedIoPoint = false;
            if (this._resetConditionAction instanceof LogicalExpression) {
                for (ASTIdentifier usedIidentifier : this._usedResetIdentifiers) {
                    int channel;
                    if (!(usedIidentifier instanceof ASTDeviceIdentifier)) continue;
                    ASTDeviceIdentifier usedDeviceIdentifier = (ASTDeviceIdentifier)usedIidentifier;
                    if (usedDeviceIdentifier.getDeviceString().equalsIgnoreCase("din")) {
                        if (null == IoLogMonitor.getLastInputEvent() || IoLogMonitor.getLastIoEvent() != IoLogMonitor.getLastInputEvent()) continue;
                        channel = usedDeviceIdentifier.getChannel();
                        affectedIoPoint |= (IoLogMonitor.getLastInputEvent().mask >> channel - 1 & 1) == 1;
                        continue;
                    }
                    if (usedDeviceIdentifier.getDeviceString().equalsIgnoreCase("rout")) {
                        if (null == IoLogMonitor.getLastOutputEvent() || IoLogMonitor.getLastIoEvent() != IoLogMonitor.getLastOutputEvent()) continue;
                        channel = usedDeviceIdentifier.getChannel();
                        affectedIoPoint |= (IoLogMonitor.getLastOutputEvent().mask >> channel - 1 & 1) == 1;
                        continue;
                    }
                    affectedIoPoint = true;
                }
            }
            if (affectedIoPoint) {
                boolean result = this._resetConditionAction.getResult();
                if (DEBUG.ON) {
                    System.out.println(this._name + " monitor reset result: " + result);
                }
                if (result) {
                    TRIGGER_LOG.info(this.getName() + " process reset");
                    this._reset = true;
                    ThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            for (Action action : MonitorTrigger.this._resetActions) {
                                try {
                                    action.execute();
                                }
                                catch (Throwable ex) {
                                    Throwable throwable = new RuntimeException("error executing reset actions for " + MonitorTrigger.this.getName() + " monitor trigger").initCause(ex);
                                    AppLog.error(throwable);
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable ex) {
            AppLog.error("error evaluating monitor loop", ex);
        }
    }
}

