/*
 * Decompiled with CFR 0.152.
 */
package com.integ.taskerjson;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.RegistryHelper;
import java.io.File;

public class Config {
    private static final String APPDATA_ROOT = "AppData/" + Application.getAppName();
    public static final File SNAP_DIRECTORY = new File("/flash/snap");
    public static final File CONFIG_DIRECTORY = new File(String.format("%s/config", SNAP_DIRECTORY.getPath()));
    public static final File SNAPS_DIRECTORY = new File(String.format("%s/snaps", SNAP_DIRECTORY.getPath()));

    static void init() {
        Config.initializeDirectoryStructure();
        Config.getAsciiCommandServerPort();
        Config.getAsciiCommandSerialPort();
        Config.getAsciiCommandSerialPortSettings();
    }

    private static void initializeDirectoryStructure() {
        AppLog.info("initialize directory structure");
        if (!SNAP_DIRECTORY.exists()) {
            SNAP_DIRECTORY.mkdir();
        }
        if (!CONFIG_DIRECTORY.exists()) {
            CONFIG_DIRECTORY.mkdir();
        }
        if (!SNAPS_DIRECTORY.exists()) {
            SNAPS_DIRECTORY.mkdir();
        }
    }

    public static int getAsciiCommandServerPort() {
        return RegistryHelper.getRegistryKey(String.format("%s/AsciiCommandServerPort", APPDATA_ROOT), 9210);
    }

    static String getAsciiCommandSerialPort() {
        return RegistryHelper.getRegistryKey(String.format("%s/AsciiCommandSerialPort", APPDATA_ROOT), "none");
    }

    static String[] getAsciiCommandSerialPortSettings() {
        return RegistryHelper.getRegistryKeys(String.format("%s/AsciiCommandSerialPortSettings", APPDATA_ROOT), "9600,8,1,0");
    }
}

