/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generating Json for colour blocks.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Json.timing');

goog.require('Blockly.Json');


Blockly.Json['timing_delay'] = function (block) {
  var duration = Blockly.Json.valueToCode(block, 'DURATION', Blockly.Json.ORDER_ATOMIC);
  var codeJson = { Type: 'Timing', Method: 'SleepMillis', Params: { Duration: duration } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['timing_delay_seconds'] = function (block) {
  var duration = Blockly.Json.valueToCode(block, 'DURATION', Blockly.Json.ORDER_ATOMIC);
  var codeJson = { Type: 'Timing', Method: 'SleepSeconds', Params: { Duration: duration } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};


Blockly.Json['clock_time_range'] = function (block) {
  var from_hour = block.getFieldValue('FROM_HOUR')
  var from_minute = block.getFieldValue('FROM_MINUTE')
  var to_hour = block.getFieldValue('TO_HOUR')
  var to_minute = block.getFieldValue('TO_MINUTE')

  var codeJson = { Type: 'Timing', Method: 'TimeRange', Params: { From: from_hour + ':' + from_minute, To: to_hour + ':' + to_minute } };
  var code = JSON.stringify(codeJson);
  return [code, Blockly.Json.ORDER_ATOMIC];
};


Blockly.Json['schedule_day_of_week'] = function (block) {
  var checkbox_sunday = block.getFieldValue('SUNDAY') == 'TRUE';
  var checkbox_monday = block.getFieldValue('MONDAY') == 'TRUE';
  var checkbox_tuesday = block.getFieldValue('TUESDAY') == 'TRUE';
  var checkbox_wednesday = block.getFieldValue('WEDNESDAY') == 'TRUE';
  var checkbox_thursday = block.getFieldValue('THURSDAY') == 'TRUE';
  var checkbox_friday = block.getFieldValue('FRIDAY') == 'TRUE';
  var checkbox_saturday = block.getFieldValue('SATURDAY') == 'TRUE';

  var codeJson = {
    Type: 'Timing', Method: 'MultiDayOfWeek', Params: {
      Sunday: checkbox_sunday,
      Monday: checkbox_monday,
      Tuesday: checkbox_tuesday,
      Wednesday: checkbox_wednesday,
      Thursday: checkbox_thursday,
      Friday: checkbox_friday,
      Saturday: checkbox_saturday
    }
  };
  var code = JSON.stringify(codeJson);
  return [code, Blockly.Json.ORDER_ATOMIC];
};



Blockly.Json['schedule_at'] = function (block) {
  var text_hour = block.getFieldValue('HOUR');
  var text_minute = block.getFieldValue('MINUTE');
  var branch = Blockly.Json.statementToCode(block, 'STATEMENTS');
  var branchJson = [];
  if ('' !== branch) branchJson = JSON.parse('[' + branch + ']');

  var codeJson = { Type: 'Trigger', Method: 'ScheduleAt', Params: { Name: 'Schedule', TimeOfDay: text_hour + ':' + text_minute, Statements: branchJson } };
  var code = JSON.stringify(codeJson);
  return code;
};



Blockly.Json['expiration_timer_start'] = function (block) {
  var name = block.getFieldValue('NAME');
  var durationInSeconds = block.getFieldValue('DURATION');

  var codeJson = { Type: 'Timing', Method: 'StartExpirationTimer', Params: { Name: name, Duration: durationInSeconds } };
  var code = JSON.stringify(codeJson);
  return code;
};



Blockly.Json['expiration_timer_expired'] = function (block) {
  var name = block.getFieldValue('NAME');

  var codeJson = { Type: 'Timing', Method: 'ExpirationTimerExpired', Params: { Name: name } };
  var code = JSON.stringify(codeJson);
  return [code, Blockly.Json.ORDER_ATOMIC];
};