/*
 * Decompiled with CFR 0.152.
 */
package com.integ.taskerjson;

import com.integ.taskerjson.Config;
import com.integ.taskerjson.SnapAsciiCommandClient;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.comm.SerialInputStream;
import com.integpg.janoslib.io.AppLog;
import java.io.InputStream;

public class SnapAsciiCommandSerialClient {
    public static void init() {
        String serialPortName = Config.getAsciiCommandSerialPort();
        System.out.println("serial port name: " + serialPortName);
        AUXSerialPort serialPort = null;
        if ("aux".equalsIgnoreCase(serialPortName)) {
            serialPort = new AUXSerialPort();
        } else if ("com".equalsIgnoreCase(serialPortName) || "rs232".equalsIgnoreCase(serialPortName)) {
            serialPort = new COMSerialPort();
        }
        System.out.println("serial port: " + serialPort);
        if (null != serialPort) {
            try {
                serialPort.open();
            }
            catch (Exception ex) {
                AppLog.error("error opening serial port: " + serialPortName, ex);
            }
            String[] serialPortSettings = Config.getAsciiCommandSerialPortSettings();
            try {
                if (4 != serialPortSettings.length) {
                    throw new RuntimeException("incorrect number of serial port parameters");
                }
                serialPort.setSerialPortParams(Integer.parseInt(serialPortSettings[0]), Integer.parseInt(serialPortSettings[1]), Integer.parseInt(serialPortSettings[2]), Integer.parseInt(serialPortSettings[3]));
            }
            catch (Exception ex) {
                AppLog.error("error setting serial params: " + serialPortSettings, ex);
            }
            try {
                AppLog.info("init snap ascii serial client on " + serialPortName + " port");
                SerialInputStream inputStream = serialPort.getInputStream();
                SnapAsciiCommandClient asciiCommandClient = new SnapAsciiCommandClient(serialPortName, (InputStream)inputStream);
                asciiCommandClient.start();
            }
            catch (Exception ex) {
                AppLog.error("error starting serial port ascii command client: " + serialPortName, ex);
            }
        }
    }
}

