/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.triggers;

import com.integ.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integ.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.snap.triggers.InternalIoMonitorTrigger;
import com.integ.snap.triggers.IntervalTrigger;
import com.integ.snap.triggers.MonitorTrigger;
import com.integ.snap.triggers.TimeTrigger;
import com.integ.snap.triggers.Trigger;
import com.integ.taskerjson.messagehandlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import java.util.Enumeration;
import java.util.Hashtable;

public class TriggerCollection
implements Runnable {
    private static final TriggerCollection TRIGGER_COLLECTION = new TriggerCollection();
    private static final Hashtable<String, Trigger> EventTriggerCollectionByGuid = new Hashtable();
    private static final Hashtable<String, Trigger> TimeTriggerCollectionByGuid = new Hashtable();
    private final DigitalInputsIoLogMonitor _inputMonitor;
    private final DigitalOutputsIoLogMonitor _outputMonitor;
    private Thread _thread = null;

    public TriggerCollection() {
        AppLog.info("start io log monitor");
        this._inputMonitor = new DigitalInputsIoLogMonitor();
        this._inputMonitor.start();
        this._outputMonitor = new DigitalOutputsIoLogMonitor();
        this._outputMonitor.start();
    }

    public static void addTrigger(Trigger trigger) {
        if (!trigger.isDisabled()) {
            System.out.println("add trigger: " + trigger.getName() + ":" + trigger.getGuid());
            if (null == trigger.getGuid()) {
                throw new RuntimeException("GUID is NULL");
            }
            if (trigger instanceof TimeTrigger) {
                TimeTriggerCollectionByGuid.put(trigger.getGuid(), trigger);
            } else if (trigger instanceof IntervalTrigger) {
                try {
                    trigger.evaluate();
                }
                catch (Throwable ex) {
                    Throwable throwable = new Exception("error evaluating interval trigger " + trigger.getName()).initCause(ex);
                    ErrorMessage errorMessage = new ErrorMessage(throwable);
                    MessagePumpEngine.postMessage(errorMessage.build());
                    AppLog.error(throwable);
                }
            } else if (trigger instanceof MonitorTrigger) {
                EventTriggerCollectionByGuid.put(trigger.getGuid(), trigger);
            } else if (trigger instanceof InternalIoMonitorTrigger) {
                InternalIoMonitorTrigger internalIoMonitorTrigger = (InternalIoMonitorTrigger)trigger;
                switch (internalIoMonitorTrigger.getType()) {
                    case "DIN": {
                        TriggerCollection.TRIGGER_COLLECTION._inputMonitor.addIoLogEventListener(internalIoMonitorTrigger);
                        break;
                    }
                    case "ROUT": {
                        TriggerCollection.TRIGGER_COLLECTION._outputMonitor.addIoLogEventListener(internalIoMonitorTrigger);
                    }
                }
            }
        }
        TRIGGER_COLLECTION.start();
    }

    public static void removeTrigger(Trigger trigger) {
        if (!trigger.isDisabled()) {
            System.out.println("remove trigger: " + trigger.getName() + ":" + trigger.getGuid());
            if (!(trigger instanceof TimeTrigger) && !(trigger instanceof IntervalTrigger)) {
                if (trigger instanceof MonitorTrigger) {
                    EventTriggerCollectionByGuid.remove(trigger.getGuid());
                } else if (trigger instanceof InternalIoMonitorTrigger) {
                    InternalIoMonitorTrigger internalIoMonitorTrigger = (InternalIoMonitorTrigger)trigger;
                    switch (internalIoMonitorTrigger.getType()) {
                        case "DIN": {
                            TriggerCollection.TRIGGER_COLLECTION._inputMonitor.removeIoLogEventListener(internalIoMonitorTrigger);
                            break;
                        }
                        case "ROUT": {
                            TriggerCollection.TRIGGER_COLLECTION._outputMonitor.removeIoLogEventListener(internalIoMonitorTrigger);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        TriggerCollection triggerCollection = this;
        synchronized (triggerCollection) {
            if (null == this._thread) {
                this._thread = new Thread(this);
                this._thread.setName(this.getClass().getName());
                this._thread.setDaemon(true);
                this._thread.start();
            }
        }
    }

    @Override
    public void run() {
        System.out.println("run " + Thread.currentThread().getName());
        while (true) {
            this.processTimeTriggerCollection();
            this.processEventTriggerCollection();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void processTimeTriggerCollection() {
        Enumeration<Trigger> e = TimeTriggerCollectionByGuid.elements();
        while (e.hasMoreElements()) {
            Trigger trigger = e.nextElement();
            try {
                trigger.evaluate();
            }
            catch (Throwable ex) {
                AppLog.error("error evaluating " + trigger.getName(), ex);
            }
        }
    }

    private void processEventTriggerCollection() {
        Enumeration<Trigger> e = EventTriggerCollectionByGuid.elements();
        while (e.hasMoreElements()) {
            Trigger trigger = e.nextElement();
            try {
                trigger.evaluate();
            }
            catch (Throwable ex) {
                AppLog.error("error evaluating " + trigger.getName(), ex);
            }
        }
    }
}

