/*
 * Decompiled with CFR 0.152.
 */
package com.integ.slaveservice;

import com.integ.slaveservice.AssemblyInfo;
import com.integ.slaveservice.LocalSlaveService;
import com.integ.slaveservice.RemoteSlaveService;
import com.integ.slaveservice.SlaveConfigInfo;
import com.integ.slaveservice.SlaveService;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.messaging.MessageLoop;
import com.integpg.janoslib.messaging.RegistryMessageListener;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.JANOS;
import java.util.Hashtable;

public class SlaveServiceMain
implements RegistryMessageListener {
    private final Hashtable _slaveServices = new Hashtable();
    private final SlaveConfigInfo[] _channelConfig = new SlaveConfigInfo[16];

    public void main(String[] args) {
        try {
            Application.init(new AssemblyInfo());
            Application.enableApplicationWatchdog(4);
            SlaveServiceMain ssm = new SlaveServiceMain();
            ssm.init();
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    private void init() {
        this._slaveServices.put("localhost", LocalSlaveService.getInstance());
        String localIpAddress = JANOS.getRegistryString((String)"ipconfig/ipaddress", null);
        if (null != localIpAddress) {
            this._slaveServices.put(localIpAddress, LocalSlaveService.getInstance());
        }
        this.setupMessageLoopListeners();
        this.loadInititalRegistryConfig();
        Application.sleepForever();
    }

    private void setupMessageLoopListeners() {
        MessageLoop.addRegistryListener(this);
    }

    @Override
    public void registryMessageReceived(String registryKey) {
        try {
            if (this.isInputSlavingKey(registryKey)) {
                this.processInputSlaveKey(registryKey);
            } else if (this.isOutputSlavingKey(registryKey)) {
                this.processOutputSlaveKey(registryKey);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Error processing registry key change", ex);
        }
    }

    private void loadInititalRegistryConfig() {
        String key;
        int i;
        for (i = 0; i < UnitConfig.getInputCount(); ++i) {
            key = "IO/Inputs/din" + (i + 1) + "/Slave";
            this.processInputSlaveKey(key);
        }
        for (i = 0; i < 16; ++i) {
            key = "IO/Outputs/rout" + (i + 1) + "/Slave";
            this.processOutputSlaveKey(key);
        }
    }

    private boolean isInputSlavingKey(String registryKey) {
        return (registryKey = registryKey.toLowerCase()).contains("inputs") && registryKey.endsWith("slave");
    }

    private boolean isOutputSlavingKey(String registryKey) {
        return (registryKey = registryKey.toLowerCase()).contains("outputs") && registryKey.endsWith("slave");
    }

    private void processInputSlaveKey(String registryKey) {
        System.out.println("Process: " + registryKey);
        int channel = this.getChannelFromSlaveKey(registryKey);
        SlaveConfigInfo slaveConfigInfo = this.getSlaveConfigInfo(registryKey);
        this.checkConfigChange(channel, slaveConfigInfo);
        if (slaveConfigInfo != null) {
            AppLog.info("Load slaving configuration for channel " + channel + ": " + slaveConfigInfo.toString());
            this._channelConfig[channel - 1] = slaveConfigInfo;
            if (!this._slaveServices.containsKey(slaveConfigInfo.IPAddress)) {
                RemoteSlaveService rss = this.createRemoteSlaveService(slaveConfigInfo.IPAddress, slaveConfigInfo.Port, slaveConfigInfo.Username, slaveConfigInfo.Password);
                this._slaveServices.put(slaveConfigInfo.IPAddress, rss);
            }
            SlaveService slaveService = (SlaveService)this._slaveServices.get(slaveConfigInfo.IPAddress);
            System.out.println("slaveConfigInfo.IOPoint: " + slaveConfigInfo.IOPoint);
            if (slaveConfigInfo.IOPoint.startsWith("din")) {
                int inputChannel = Integer.parseInt(slaveConfigInfo.IOPoint.substring(3));
                slaveService.addRule(0, channel, 0, inputChannel, slaveConfigInfo.Inverted);
            } else if (slaveConfigInfo.IOPoint.startsWith("rout")) {
                int outputChannel = Integer.parseInt(slaveConfigInfo.IOPoint.substring(4));
                slaveService.addRule(0, channel, 1, outputChannel, slaveConfigInfo.Inverted);
            }
        }
    }

    private void processOutputSlaveKey(String registryKey) {
        System.out.println("Process: " + registryKey);
        int channel = this.getChannelFromSlaveKey(registryKey);
        SlaveConfigInfo slaveConfigInfo = this.getSlaveConfigInfo(registryKey);
        this.checkConfigChange(channel, slaveConfigInfo);
        if (slaveConfigInfo != null) {
            AppLog.info("Load slaving configuration for channel " + channel + ": " + slaveConfigInfo.toString());
            this._channelConfig[channel - 1] = slaveConfigInfo;
            if (!this._slaveServices.containsKey(slaveConfigInfo.IPAddress)) {
                RemoteSlaveService rss = this.createRemoteSlaveService(slaveConfigInfo.IPAddress, slaveConfigInfo.Port, slaveConfigInfo.Username, slaveConfigInfo.Password);
                this._slaveServices.put(slaveConfigInfo.IPAddress, rss);
            }
            SlaveService slaveService = (SlaveService)this._slaveServices.get(slaveConfigInfo.IPAddress);
            if (slaveConfigInfo.IOPoint.startsWith("din")) {
                int inputChannel = Integer.parseInt(slaveConfigInfo.IOPoint.substring(3));
                slaveService.addRule(1, channel, 0, inputChannel, slaveConfigInfo.Inverted);
            } else if (slaveConfigInfo.IOPoint.startsWith("rout")) {
                int outputChannel = Integer.parseInt(slaveConfigInfo.IOPoint.substring(4));
                slaveService.addRule(1, channel, 1, outputChannel, slaveConfigInfo.Inverted);
            }
            slaveService.setFailedCommOutputState(channel, slaveConfigInfo.FailedCommString);
        }
    }

    private int getChannelFromSlaveKey(String slaveRegistryKey) {
        slaveRegistryKey = slaveRegistryKey.toLowerCase();
        int channel = -1;
        if (slaveRegistryKey.contains("outputs/rout")) {
            int routPos = slaveRegistryKey.indexOf("rout");
            int nextForewardSlashPos = slaveRegistryKey.indexOf("/", routPos);
            channel = Integer.parseInt(slaveRegistryKey.substring(routPos + 4, nextForewardSlashPos));
        } else if (slaveRegistryKey.contains("inputs/din")) {
            int dinPos = slaveRegistryKey.indexOf("din");
            int nextForewardSlashPos = slaveRegistryKey.indexOf("/", dinPos);
            channel = Integer.parseInt(slaveRegistryKey.substring(dinPos + 3, nextForewardSlashPos));
        }
        if (-1 != channel) {
            return channel;
        }
        throw new RuntimeException("Not a slaving registry key");
    }

    private SlaveConfigInfo getSlaveConfigInfo(String slaveRegistryKey) {
        String value = JANOS.getRegistryString((String)slaveRegistryKey, (String)"");
        if ("".equals(value)) {
            return null;
        }
        return new SlaveConfigInfo(value);
    }

    private void checkConfigChange(int channel, SlaveConfigInfo slaveConfigInfo) {
    }

    private RemoteSlaveService createRemoteSlaveService(String ipAddress, int port, String username, String password) {
        RemoteSlaveService rss = new RemoteSlaveService(ipAddress, port, username, password);
        return rss;
    }
}

