/*
 * Decompiled with CFR 0.152.
 */
package com.integ.slaveservice;

import com.integ.slaveservice.SlaveService;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.Application;
import com.integpg.system.JANOS;
import java.io.IOException;

public class LocalSlaveService
extends SlaveService {
    private static final LocalSlaveService INSTANCE = new LocalSlaveService();

    public static LocalSlaveService getInstance() {
        return INSTANCE;
    }

    private LocalSlaveService() {
        this._log = FileLog.getHalfBackupLog(new LogOptions(Application.getAppName() + "_localhost.log"));
    }

    @Override
    protected void monitor() {
        AppLog.info("Starting Local Slave Service");
        this._monitorThread = new Thread(this);
        this._monitorThread.setDaemon(true);
        this._monitorThread.setName(this.getClass().getName() + ":localhost");
        this._monitorThread.start();
    }

    @Override
    public void run() {
        AppLog.info("Local Slave Service has started");
        this._running = true;
        while (this._running) {
            int usedOutputMask = 0;
            int newOutputs = 0;
            int remoteInputs = JANOS.getInputStates();
            int remoteOutputs = JANOS.getOutputStates();
            for (SlaveService.Rule rule : this._rules) {
                int state = 0;
                int remoteChannel = rule.RemoteIoChannel;
                state = 0 == rule.RemoteIoType ? remoteInputs >> remoteChannel - 1 & 1 : remoteOutputs >> remoteChannel - 1 & 1;
                if (rule.Invert) {
                    state = (state + 1) % 2;
                }
                int localChannel = rule.LocalIoChannel;
                if (0 == rule.LocalIoType) {
                    JANOS.setInputConditioning((int)(localChannel - 1), (int)(1 == state ? 3 : 2));
                    continue;
                }
                usedOutputMask |= 1 << localChannel - 1;
                newOutputs |= state << localChannel - 1;
            }
            try {
                JANOS.setOutputStates((int)newOutputs, (int)usedOutputMask);
            }
            catch (IOException ex) {
                this._log.error(ex);
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        AppLog.info("Local Slave Service has stopped");
    }
}

