/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.janoslib.iolog.DigitalInputChannelEvent;
import com.integ.janoslib.iolog.IoChannelEvent;
import com.integ.janoslib.iolog.IoChannelLogListener;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.QuickDateFormat;
import java.util.ArrayList;

public class DigitalInputMonitor
implements IoChannelLogListener {
    public static final DigitalInputChannelEvent[] DIGITAL_INPUTS = new DigitalInputChannelEvent[UnitConfig.getInputCount()];
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss.fff");
    private final ArrayList<IoChannelLogListener> _digitalInputListeners = new ArrayList();

    public void addDigitalInputListener(IoChannelLogListener ioChannelLogListener) {
        this._digitalInputListeners.add(ioChannelLogListener);
        System.out.println(String.format("%d digital input listeners", this._digitalInputListeners.size()));
    }

    public void removeDigitalInputListener(IoChannelLogListener ioChannelLogListener) {
        this._digitalInputListeners.remove(ioChannelLogListener);
        System.out.println(String.format("%d digital input listeners", this._digitalInputListeners.size()));
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        DigitalInputChannelEvent digitalInputChannelEvent;
        DigitalInputMonitor.DIGITAL_INPUTS[digitalInputChannelEvent.Channel - 1] = digitalInputChannelEvent = (DigitalInputChannelEvent)ioEvent;
        this.alertDigitalInputListeners(digitalInputChannelEvent);
    }

    private void alertDigitalInputListeners(DigitalInputChannelEvent digitalInputChannelEvent) {
        for (IoChannelLogListener ioChannelLogListener : this._digitalInputListeners) {
            if (null == ioChannelLogListener) continue;
            long start = System.currentTimeMillis();
            ioChannelLogListener.onIoChannelEvent(digitalInputChannelEvent);
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("alerting digital input listener took " + elapsed);
        }
    }

    static {
        for (int chan = 0; chan < UnitConfig.getInputCount(); ++chan) {
            DigitalInputMonitor.DIGITAL_INPUTS[chan] = new DigitalInputChannelEvent();
            DigitalInputMonitor.DIGITAL_INPUTS[chan].Channel = chan + 1;
        }
    }
}

