/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Helpers.Telnet;

import JniorProtocol.Helpers.Telnet.TelnetListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.EventObject;
import java.util.Vector;

public class TelnetProtocol {
    private static final boolean DEBUG = false;
    private static final String BYE = "bye\n";
    private String byeRemaining = "bye\n";
    private Vector telnet_listener = new Vector();
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private boolean echo = false;
    private String response = new String();
    private boolean shutdown = true;
    private StringBuilder unprocessedData = new StringBuilder();

    public TelnetProtocol(String string) {
        try {
            this.socket = new Socket(string, 23);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            new Thread(new Runnable(){

                public void run() {
                    byte[] byArray = new byte[1024];
                    TelnetProtocol.this.shutdown = false;
                    while (!TelnetProtocol.this.shutdown) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        try {
                            if (TelnetProtocol.this.in.available() <= 0) continue;
                            int n = TelnetProtocol.this.in.read(byArray);
                            TelnetProtocol.this.unprocessedData.append(new String(byArray, 0, n));
                            TelnetProtocol.this.receive(byArray, n);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            TelnetProtocol.this.shutdown = true;
                        }
                    }
                }
            }).start();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void disconnect() throws IOException {
        this.socket.close();
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        return this.socket.isConnected();
    }

    public void receive(byte[] byArray, int n) {
        int n2;
        String string = new String(byArray, 0, n);
        String string2 = new String();
        for (n2 = 0; n2 < n; ++n2) {
            if (string.charAt(n2) <= '\u0080') {
                string2 = string2 + string.charAt(n2);
                continue;
            }
            n2 += 2;
        }
        for (n2 = 0; n2 < this.telnet_listener.size(); ++n2) {
            ((TelnetListener)this.telnet_listener.get(n2)).GetResponse(string2, this.echo);
        }
        if ((string2.indexOf("Connection Terminated") >= 0 || string2.indexOf("Connection to host lost") >= 0 || string2.indexOf("FTP server stopped") >= 0) && this.telnet_listener != null) {
            for (n2 = 0; n2 < this.telnet_listener.size(); ++n2) {
                ((TelnetListener)this.telnet_listener.get(n2)).connectionLost(new EventObject(this));
            }
        }
    }

    public void sendCommand(String string) {
        this.resetUnprocessedData();
        this.send(string + "\r\n");
    }

    public void send(String string) {
        if (string != null) {
            this.response = string.length() > 1 ? string : string;
        }
        try {
            this.out.write(string.getBytes());
            this.out.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.byeRemaining = this.byeRemaining.indexOf(string) == 0 ? this.byeRemaining.substring(string.length()) : BYE;
        this.response = new String();
    }

    public void addTelnetListener(TelnetListener telnetListener) {
        for (int i = 0; i < this.telnet_listener.size(); ++i) {
            if ((TelnetListener)this.telnet_listener.get(i) != telnetListener) continue;
            return;
        }
        this.telnet_listener.add(telnetListener);
    }

    public String getUnprocessedData() {
        String string = this.unprocessedData.toString();
        System.out.println(string);
        return string;
    }

    private void resetUnprocessedData() {
        this.unprocessedData.setLength(0);
    }
}

