/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.nodes;

import com.integ.scripting.nodes.AbstractNode;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.lexer.Token;

public class LogicalNode
extends AbstractNode {
    public Token Operator;
    public AbstractNode Left;
    public AbstractNode Right;

    public LogicalNode(Token operator, AbstractNode left, AbstractNode right) {
        this.Operator = operator;
        this.Left = left;
        this.Right = right;
    }

    public String toString() {
        return String.format("%s %s %s", this.Left.toString(), this.Operator.content, this.Right.toString());
    }

    @Override
    public Object execute(Scope scope) {
        boolean _debug_ = scope.isDebug();
        if (_debug_) {
            System.out.println("Left = " + this.Left);
        }
        Object leftResultObject = this.Left.execute(scope);
        if (_debug_) {
            System.out.println("leftResultObject = " + leftResultObject);
        }
        if (_debug_ && null != leftResultObject) {
            System.out.println("leftResultObject = " + leftResultObject + " " + leftResultObject.getClass());
        }
        if (_debug_) {
            System.out.println("Right = " + this.Right);
        }
        Object rightResultObject = this.Right.execute(scope);
        if (_debug_) {
            System.out.println("rightResultObject = " + rightResultObject);
        }
        if (_debug_ && null != rightResultObject) {
            System.out.println("rightResultObject = " + rightResultObject + " " + rightResultObject.getClass());
        }
        try {
            switch (this.Operator.type) {
                case 11: {
                    if (null == leftResultObject && null == rightResultObject) {
                        return true;
                    }
                    if (null != leftResultObject && null != rightResultObject) {
                        if (leftResultObject instanceof Boolean && rightResultObject instanceof Boolean) {
                            return ((Boolean)leftResultObject).equals((Boolean)rightResultObject);
                        }
                        return ((Number)leftResultObject).doubleValue() == ((Number)rightResultObject).doubleValue();
                    }
                    return false;
                }
                case 12: {
                    if (null == leftResultObject && null == rightResultObject) {
                        return false;
                    }
                    if (null != leftResultObject && null != rightResultObject) {
                        if (leftResultObject instanceof Boolean && rightResultObject instanceof Boolean) {
                            return ((Boolean)leftResultObject).equals((Boolean)rightResultObject);
                        }
                        return ((Number)leftResultObject).doubleValue() != ((Number)rightResultObject).doubleValue();
                    }
                    return true;
                }
                case 60: {
                    return ((Number)leftResultObject).doubleValue() < ((Number)rightResultObject).doubleValue();
                }
                case 62: {
                    return ((Number)leftResultObject).doubleValue() > ((Number)rightResultObject).doubleValue();
                }
            }
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(String.format("%s is not the same type as %s", leftResultObject.getClass(), rightResultObject.getClass()), ex);
        }
        throw new RuntimeException("Invalid Logical Operator Type: " + this.Operator);
    }
}

