/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.Time;

import com.dalsemi.system.Clock;
import java.util.Calendar;
import java.util.Date;

public class QuickDateStamp {
    private static long tRef = 0L;
    private static long nextMinute = 0L;
    private static String sPrefix = null;

    public QuickDateStamp() {
        QuickDateStamp.getDateStamp();
    }

    public static void invalidate() {
        tRef = Integer.MAX_VALUE;
    }

    public static String getDateStamp() {
        return QuickDateStamp.getDateStamp(Clock.getTickCount());
    }

    public static String getDateStamp(long time) {
        if (sPrefix == null || tRef > time || time > nextMinute) {
            QuickDateStamp.InitRefs(time);
        }
        int delta = (int)(time - tRef);
        int rSecond = delta / 1000;
        int rMillis = delta - 1000 * rSecond;
        return sPrefix + Integer.toString(rSecond + 100).substring(1) + "." + Integer.toString(rMillis + 1000).substring(1);
    }

    private static void InitRefs(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        int rMonth = cal.get(2);
        int rDay = cal.get(5);
        int rYear = cal.get(1);
        int rHour = cal.get(11);
        int rMinute = cal.get(12);
        int rSecond = cal.get(13);
        int rMillis = cal.get(14);
        tRef = time - (long)(1000 * rSecond + rMillis);
        nextMinute = time + 60000L - time % 60000L;
        StringBuffer buf = new StringBuffer(32);
        buf.append(Integer.toString(rMonth + 101).substring(1));
        buf.append("/");
        buf.append(Integer.toString(rDay + 100).substring(1));
        buf.append("/");
        buf.append(Integer.toString(rYear).substring(2));
        buf.append(" ");
        buf.append(Integer.toString(rHour + 100).substring(1));
        buf.append(":");
        buf.append(Integer.toString(rMinute + 100).substring(1));
        buf.append(":");
        sPrefix = buf.toString();
    }
}

