/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.logging;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedLineOutputStream
extends BufferedOutputStream {
    public BufferedLineOutputStream(OutputStream out) {
        super(out);
    }

    public BufferedLineOutputStream(OutputStream out, int size) {
        super(out, size);
    }

    @Override
    public synchronized void write(byte[] bytes, int offset, int len) throws IOException {
        if (len >= this.buf.length) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
            this.out.write(bytes, offset, len);
        } else {
            int remainingBytes = this.buf.length - this.count;
            if (len >= remainingBytes) {
                this.out.write(this.buf, 0, this.count);
                this.count = 0;
            }
            System.arraycopy(bytes, offset, this.buf, this.count, len);
            this.count += len;
        }
    }
}

