/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.Immutable;

import com.dalsemi.system.ArrayUtils;
import com.integpg.EmbeddedHelpers.ExceptionHandler;
import com.integpg.EmbeddedHelpers.Time.QuickTime;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Date;

public class BufferEntry {
    public static final int RECORD_LEN_POS = 1;
    public static final int TIMESTAMP_POS = 3;
    public static final int EVENT_TYPE_POS = 11;
    public static final int DATA_POS = 12;
    public static final int DATA = 1;
    public static final int BLACKOUT = 2;
    public static final int OVERWRITE = 3;
    public int m_immutableBufferAddress;
    public byte[] m_bytes = null;
    public int m_size = 0;
    public long m_timestamp;
    public int m_eventType = 1;
    public int m_dataSize;
    private byte[] m_lastRecord = new byte[1024];

    public BufferEntry() {
    }

    public BufferEntry(byte[] bytes) throws Exception {
        this.setData(bytes);
    }

    public void setData(byte[] data) throws Exception {
        this.setData(data, QuickTime.getTimeMillis());
    }

    public void setData(byte[] data, long timestamp) throws Exception {
        if (timestamp != -1L) {
            this.m_timestamp = timestamp;
        }
        this.m_dataSize = data.length;
        this.m_size = 12 + this.m_dataSize;
        if (this.m_bytes == null || this.m_bytes.length < this.m_size) {
            this.m_bytes = new byte[this.m_size];
        }
        this.m_bytes[0] = -66;
        ArrayUtils.setShort(this.m_bytes, 1, (short)this.m_size);
        ArrayUtils.setLong(this.m_bytes, 3, this.m_timestamp);
        this.m_bytes[11] = (byte)this.m_eventType;
        ArrayUtils.arraycopy(data, 0, this.m_bytes, 12, this.m_dataSize);
    }

    public void parse(DataInputStream dis) throws EOFException, IOException {
        if ((dis.read() & 0xFF) != 190) {
            throw new IOException("Non Buffer Entry");
        }
        this.m_size = dis.readShort();
        this.m_bytes = new byte[this.m_size];
        this.m_bytes[0] = -66;
        ArrayUtils.setShort(this.m_bytes, 1, (short)this.m_size);
        dis.read(this.m_bytes, 3, this.m_size - 3);
        this.m_timestamp = ArrayUtils.getLong(this.m_bytes, 3);
        this.m_eventType = this.m_bytes[11];
        this.m_dataSize = this.m_size + 1 - 12;
    }

    public void parse(byte[] bytes) throws Exception {
        if (bytes.length == 0) {
            return;
        }
        try {
            if ((bytes[0] & 0xFF) != 190) {
                throw new Exception("Non Buffer Entry");
            }
            this.m_bytes = new byte[bytes.length];
            ArrayUtils.arraycopy(bytes, 0, this.m_bytes, 0, bytes.length);
            this.m_size = ArrayUtils.getShort(bytes, 1);
            this.m_timestamp = ArrayUtils.getLong(bytes, 3);
            this.m_eventType = bytes[11];
            this.m_dataSize = this.m_size - 12;
        }
        catch (Exception ex) {
            this.m_size = 0;
            System.out.println("Buffer Entry Parse " + bytes.length + " bytes");
            ExceptionHandler.logException(0, ex);
        }
    }

    public void setEventType(int eventType) {
        this.m_eventType = eventType;
    }

    public byte[] getBytes() {
        return this.m_bytes;
    }

    public String toString() {
        return new Date(this.m_timestamp) + "  [" + this.m_size + "] @" + Integer.toHexString(this.m_immutableBufferAddress + 65536).substring(1);
    }
}

