/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices;

import JniorProtocol.Devices.Externals.ExternalTemperature;
import JniorProtocol.Devices.Externals.ExternalTypeF9;
import JniorProtocol.Devices.Externals.ExternalTypeFA;
import JniorProtocol.Devices.Externals.ExternalTypeFB;
import JniorProtocol.Devices.Externals.ExternalTypeFC;
import JniorProtocol.Devices.Externals.ExternalTypeFD;
import JniorProtocol.Devices.Externals.ExternalTypeFE;
import JniorProtocol.Devices.UnknownDevice;
import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Exceptions.NotYetImplementedException;
import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.Helpers.Features;
import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.EnumerationListener;
import JniorProtocol.Listeners.StateListener;
import JniorProtocol.ProtocolMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Device
extends ProtocolMessage
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final int DEVICE_TIMEOUT = 30000;
    public static final int SEND_READ_DEVICES = 21;
    public static final int RECV_READ_DEVICES = 22;
    public static final int SEND_WRITE_DEVICES = 23;
    public static final int RECV_WRITE_DEVICES = 24;
    public static final int RECV_ENUMERATE = 27;
    public static final int SEND_ENUMERATE = 26;
    public static final int SEND_SUBSCRIBE_DEVICES = 25;
    public static final int SEND_UNSUBSCRIBE_DEVICES = 28;
    public static final int ENUMERATE_INTERNAL = 1;
    public static final int ENUMERATE_EXTERNAL = 2;
    public static final int ENUMERATE_ALL = 3;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    public static final int OPEN = 0;
    public static final int CLOSED = 1;
    protected long m_address;
    protected String m_hexAddress;
    protected int m_channel;
    protected String m_description;
    protected Vector m_stateListeners = new Vector();
    protected Vector m_enumerationListeners = new Vector();
    private long[] m_deviceAddresses = null;
    private boolean m_enumerationReceived = false;
    private boolean m_subscribed = false;
    private boolean m_readDeviceReceived = false;

    public Device(JniorSession jniorSession) {
        super(jniorSession);
    }

    public Device(JniorSession jniorSession, long l) {
        super(jniorSession);
        this.m_address = l;
        this.m_hexAddress = "0000000000000000" + Long.toHexString(l).toUpperCase();
        this.m_hexAddress = this.m_hexAddress.substring(this.m_hexAddress.length() - 16);
    }

    public long getAddress() {
        return this.m_address;
    }

    public String getHexAddress() {
        return this.m_hexAddress.toUpperCase();
    }

    public boolean isSubscribed() {
        return this.m_subscribed;
    }

    public boolean compareTo(Object object) {
        return true;
    }

    public void addStateListener(StateListener stateListener) {
        if (stateListener == null) {
            return;
        }
        for (int i = 0; i < this.m_stateListeners.size(); ++i) {
            if (!((StateListener)this.m_stateListeners.elementAt(i)).equals(stateListener)) continue;
            return;
        }
        this.m_stateListeners.add(stateListener);
    }

    public void addEnumerationListener(EnumerationListener enumerationListener) {
        if (enumerationListener == null) {
            return;
        }
        for (int i = 0; i < this.m_enumerationListeners.size(); ++i) {
            if (!((EnumerationListener)this.m_enumerationListeners.elementAt(i)).equals(enumerationListener)) continue;
            return;
        }
        this.m_enumerationListeners.add(enumerationListener);
    }

    public Device[] enumerate() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        return this.enumerate(3);
    }

    public Device[] enumerate(int n) throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        return this.enumerate(n, false);
    }

    public Device[] enumerate(int n, boolean bl) throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        this.m_session.isLoggedIn();
        long l = System.currentTimeMillis();
        byte[] byArray = new byte[2];
        int n2 = 0;
        byArray[n2++] = 26;
        byArray[n2++] = (byte)n;
        try {
            this.m_enumerationReceived = false;
            this.send(byArray);
            if (bl) {
                long l2 = System.currentTimeMillis();
                while (this.m_session.isConnected() && !this.m_enumerationReceived && !this.isCommandTimeout(l2, 30000)) {
                    Thread.sleep(50L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.getDeviceArray();
    }

    private Device[] getDeviceArray() {
        Device[] deviceArray = null;
        if (this.m_enumerationReceived) {
            deviceArray = new Device[this.m_deviceAddresses.length];
            for (int i = 0; i < this.m_deviceAddresses.length; ++i) {
                deviceArray[i] = (Device)this.m_session.getDevices().get(new Long(this.m_deviceAddresses[i]));
            }
        }
        return deviceArray;
    }

    public void subscribe() throws NotYetConnectedException, NotYetImplementedException {
        this.subscribe(new long[]{this.m_address});
    }

    public void subscribe(Device[] deviceArray) throws NotYetConnectedException, NotYetImplementedException {
        long[] lArray = new long[deviceArray.length];
        for (int i = 0; i < deviceArray.length; ++i) {
            if (deviceArray[i] == null) continue;
            lArray[i] = deviceArray[i].getAddress();
        }
        this.subscribe(lArray);
    }

    public void subscribe(long[] lArray) throws NotYetConnectedException, NotYetImplementedException {
        byte[] byArray = new byte[3 + lArray.length * 8];
        int n = 0;
        byArray[n++] = 25;
        byArray = Device.setShort(byArray, n, (short)lArray.length);
        n += 2;
        for (int i = 0; i < lArray.length; ++i) {
            Device device;
            byArray = Device.setLong(byArray, n, lArray[i]);
            n += 8;
            Long l = new Long(lArray[i]);
            Hashtable hashtable = this.m_session.getDevices();
            if (hashtable == null || hashtable.get(l) == null) {
                Debug.log(Long.toHexString(lArray[i]) + " returned null for hashtable or device");
            }
            if ((device = (Device)hashtable.get(l)) == null) continue;
            device.m_subscribed = true;
        }
        try {
            this.send(byArray, 0, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void unsubscribe(Device[] deviceArray) throws NotYetConnectedException, NotYetImplementedException {
        long[] lArray = new long[deviceArray.length];
        for (int i = 0; i < deviceArray.length; ++i) {
            lArray[i] = deviceArray[i].getAddress();
        }
        this.unsubscribe(lArray);
    }

    public void unsubscribe(long[] lArray) throws NotYetConnectedException, NotYetImplementedException {
        byte[] byArray = new byte[3 + lArray.length * 8];
        int n = 0;
        byArray[n++] = 28;
        byArray = Device.setShort(byArray, n, (short)lArray.length);
        n += 2;
        for (int i = 0; i < lArray.length; ++i) {
            byArray = Device.setLong(byArray, n, lArray[i]);
            n += 8;
            Device device = (Device)this.m_session.getDevices().get(new Long(lArray[i]));
            device.m_subscribed = true;
        }
        try {
            this.send(byArray, 0, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void read() throws NotYetConnectedException, NotYetImplementedException, CommandTimeoutException {
        this.read(new long[]{this.m_address});
    }

    public void read(long[] lArray) throws CommandTimeoutException, NotYetConnectedException {
        byte[] byArray = new byte[3 + lArray.length * 8];
        int n = 0;
        byArray[n++] = 21;
        byArray = Device.setShort(byArray, n, (short)lArray.length);
        n += 2;
        for (int i = 0; i < lArray.length; ++i) {
            byArray = Device.setLong(byArray, n, lArray[i]);
            n += 8;
        }
        try {
            this.m_readDeviceReceived = false;
            this.send(byArray, 0, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            long l = System.currentTimeMillis();
            long l2 = System.currentTimeMillis();
            while (this.m_session.isConnected() && !this.m_readDeviceReceived && !this.isCommandTimeout(l2, 30000)) {
                Thread.sleep(250L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void write() throws NotYetConnectedException, NotYetImplementedException {
        this.write(new long[]{this.m_address});
    }

    public void write(long[] lArray) throws NotYetConnectedException {
        byte[] byArray = new byte[65535];
        int n = 0;
        byArray[n++] = 23;
        byArray = Device.setShort(byArray, n, (short)lArray.length);
        n += 2;
        for (int i = 0; i < lArray.length; ++i) {
            byArray = Device.setLong(byArray, n, lArray[i]);
            n += 8;
            Device device = (Device)this.m_session.getDevices().get(new Long(lArray[i]));
            if (device == null) continue;
            byte[] byArray2 = this.getWriteBytes();
            byArray = Device.setShort(byArray, n, (short)byArray2.length);
            System.arraycopy(byArray2, 0, byArray, n += 2, byArray2.length);
            n += byArray2.length;
        }
        try {
            this.send(byArray, 0, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] getWriteBytes() {
        try {
            throw new NotYetImplementedException();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void fireStateChange() {
        int n = 0;
        while (n < this.m_stateListeners.size()) {
            int n2 = n++;
            ((StateListener)this.m_stateListeners.elementAt(n2)).onStateChange(new EventObject(this.m_session), this);
        }
    }

    public void fireEnumerationReceived() {
        int n = 0;
        while (n < this.m_enumerationListeners.size()) {
            final int n2 = n++;
            new Thread(new Runnable(){

                public void run() {
                    ((EnumerationListener)Device.this.m_enumerationListeners.elementAt(n2)).enumerationReceived(new EventObject(Device.this.m_session), Device.this.getDeviceArray());
                }
            }).start();
        }
    }

    public void receive(ByteArrayInputStream byteArrayInputStream, int n) {
        try {
            switch (n) {
                case 22: {
                    int n2 = Device.getShort(byteArrayInputStream);
                    for (int i = 0; i < n2; ++i) {
                        long l = Device.getLong(byteArrayInputStream);
                        int n3 = Device.getShort(byteArrayInputStream);
                        Device device = (Device)this.m_session.getDevices().get(new Long(l));
                        if (device == null) continue;
                        device.receive(byteArrayInputStream);
                        device.m_readDeviceReceived = true;
                    }
                    break;
                }
                case 27: {
                    int n4 = byteArrayInputStream.read();
                    int n5 = Device.getShort(byteArrayInputStream);
                    this.m_deviceAddresses = new long[n5];
                    for (int i = 0; i < n5; ++i) {
                        this.m_deviceAddresses[i] = Device.getLong(byteArrayInputStream);
                        if (this.m_session.getDevices().containsKey(new Long(this.m_deviceAddresses[i]))) continue;
                        Device device = null;
                        switch ((int)(this.m_deviceAddresses[i] & 0xFFL)) {
                            case 255: {
                                int n6 = (int)(this.m_deviceAddresses[i] >> 8 & 0xFFL);
                                switch ((int)(this.m_deviceAddresses[i] >> 16 & 0xFFL)) {
                                    case 0: {
                                        device = this.m_session.getInput(n6);
                                        break;
                                    }
                                    case 1: {
                                        device = this.m_session.getOutput(n6);
                                    }
                                }
                                break;
                            }
                            case 16: 
                            case 40: {
                                device = new ExternalTemperature(this.m_session, this.m_deviceAddresses[i]);
                                break;
                            }
                            case 250: {
                                device = new ExternalTypeFA(this.m_session, this.m_deviceAddresses[i]);
                                break;
                            }
                            case 251: {
                                if (this.m_session.getInternalsInstance().m_model.contains("jr4") || this.m_session.getInternalsInstance().m_model.contains("jr3") && Features.isFeatureAvailable("TypeFB", this.m_session.getOsVersion())) {
                                    device = new ExternalTypeFB(this.m_session, this.m_deviceAddresses[i]);
                                    break;
                                }
                                device = new UnknownDevice(this.m_session, this.m_deviceAddresses[i]);
                                ((UnknownDevice)device).setReason(Features.getAvailVersion("TypeFB"));
                                break;
                            }
                            case 252: {
                                device = new ExternalTypeFC(this.m_session, this.m_deviceAddresses[i]);
                                break;
                            }
                            case 253: {
                                if (this.m_session.getInternalsInstance().m_model.contains("jr4") || this.m_session.getInternalsInstance().m_model.contains("jr3") && Features.isFeatureAvailable("TypeFD", this.m_session.getOsVersion())) {
                                    device = new ExternalTypeFD(this.m_session, this.m_deviceAddresses[i]);
                                    break;
                                }
                                device = new UnknownDevice(this.m_session, this.m_deviceAddresses[i]);
                                ((UnknownDevice)device).setReason(Features.getAvailVersion("TypeFD"));
                                break;
                            }
                            case 254: {
                                if (this.m_session.getInternalsInstance().m_model.contains("jr4") || this.m_session.getInternalsInstance().m_model.contains("jr3") && Features.isFeatureAvailable("TypeFE", this.m_session.getOsVersion())) {
                                    device = new ExternalTypeFE(this.m_session, this.m_deviceAddresses[i]);
                                    break;
                                }
                                device = new UnknownDevice(this.m_session, this.m_deviceAddresses[i]);
                                ((UnknownDevice)device).setReason(Features.getAvailVersion("TypeFD"));
                                break;
                            }
                            case 249: {
                                if (this.m_session.getInternalsInstance().m_model.contains("jr4")) {
                                    device = new ExternalTypeF9(this.m_session, this.m_deviceAddresses[i]);
                                    break;
                                }
                                device = new UnknownDevice(this.m_session, this.m_deviceAddresses[i]);
                                break;
                            }
                            default: {
                                device = new UnknownDevice(this.m_session, this.m_deviceAddresses[i]);
                            }
                        }
                        if (device == null) continue;
                        this.m_session.getDevices().put(new Long(this.m_deviceAddresses[i]), device);
                    }
                    this.m_enumerationReceived = true;
                    this.fireEnumerationReceived();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Object clone() {
        return null;
    }

    public String toString() {
        return this.m_hexAddress;
    }
}

