/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.io;

import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.Log;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.ExceptionHandler;
import com.integpg.janoslib.system.MinimumVersion;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;

public class AppLog {
    private static final boolean REQUIRED_OS_VERSION = MinimumVersion.atLeast("SysLog", "1.3-b10");
    private static QuickDateFormat _dateFormat = new QuickDateFormat("MM/dd/yy HH:mm:ss zzz");
    private static Log _log;
    private static Log _exceptionLog;
    private static boolean _warnSysLog;
    private static boolean _logErrorOccured;

    private static synchronized void ensureLogFile() {
        try {
            if (_log == null && Application.getAppInstanceName() != null) {
                _log = FileLog.getLog(new LogOptions(Application.getAppInstanceName() + ".log").setMaxFileSizeInKb(64));
            }
            if (_exceptionLog == null && Application.getAppInstanceName() != null) {
                _exceptionLog = FileLog.getLog(new LogOptions(Application.getAppInstanceName() + "_exception.log").setMaxFileSizeInKb(64));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append(_dateFormat.format(System.currentTimeMillis()));
            sb.append(", ");
            sb.append(ex.toString());
            System.err.println(sb.toString());
        }
    }

    public static void setAppLog(Log log) {
        _log = log;
    }

    public static void setAppExceptionLog(Log log) {
        _exceptionLog = log;
    }

    public static void fatal(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.fatal(line);
        }
        JANOS.syslog((String)line, (int)2, (int)1);
    }

    public static void warn(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.warn(line);
        }
        AppLog.sendToSyslogServer(line, 4);
    }

    public static void error(String error) {
        AppLog.ensureLogFile();
        _log.error(error);
        AppLog.sendToSyslogServer(error, 3);
    }

    public static void error(Throwable ex) {
        String stackTrace = ExceptionHandler.getStackTrace(ex);
        AppLog.ensureLogFile();
        AppLog.anErrorHasOccuredEntry();
        if (_exceptionLog != null) {
            _exceptionLog.error(stackTrace);
        } else {
            ex.printStackTrace(System.out);
        }
        AppLog.sendToSyslogServer(ex.toString(), 3);
    }

    public static void error(String description, Throwable ex) {
        String stackTrace = ExceptionHandler.getStackTrace(ex);
        AppLog.ensureLogFile();
        AppLog.anErrorHasOccuredEntry();
        if (_exceptionLog != null) {
            _exceptionLog.error(description + ": " + stackTrace);
        } else {
            ex.printStackTrace(System.out);
        }
        AppLog.sendToSyslogServer(description + ": " + ex.toString(), 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void anErrorHasOccuredEntry() {
        if (null != _log) {
            Log log = _log;
            synchronized (log) {
                if (_log != null && _logErrorOccured) {
                    _log.error("An ERROR has occured.  Please check the application exception log");
                    _logErrorOccured = false;
                }
            }
        }
    }

    private static void sendToSyslogServer(String message, int level) {
        if (REQUIRED_OS_VERSION) {
            JANOS.syslog((String)message, (int)level, (int)2);
        } else if (_warnSysLog) {
            _log.info("!! Sending to the syslog server requires v1.3 or later");
            _warnSysLog = false;
        }
    }

    public static void debug(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.debug(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static void info(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.info(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    public static void vital(String line) {
        AppLog.ensureLogFile();
        if (_log != null) {
            _log.vital(line);
        }
        AppLog.sendToSyslogServer(line, 6);
    }

    static {
        _warnSysLog = true;
        _logErrorOccured = true;
    }
}

