/*
 * Decompiled with CFR 0.152.
 */
package SerialControl;

import SerialControl.CommandHandler;
import SerialControl.General.AssemblyInfo;
import SerialControl.TcpServer;
import com.integpg.comm.SerialPort;
import com.integpg.system.JANOS;
import integpg.EmbeddedHelpers.Base.EmbeddedBase;
import integpg.EmbeddedHelpers.Message.MessagePump;
import integpg.EmbeddedHelpers.Monitor.IOStateListener;
import integpg.EmbeddedHelpers.Monitor.IOStateMonitor;
import integpg.EmbeddedHelpers.Serial.SerialParams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SCLMain
extends EmbeddedBase {
    private static final boolean DEBUG = false;
    private static final String VERSION = AssemblyInfo.getVersion();
    private static final String APP_NAME = "SERIAL CONTROL";
    public static String REG_INCOMING_TERMINATION_STRING = "/IncomingTerminationString";
    private static final String INCOMING_TERMINATION_STRING_DEFAULT = "\\r";
    public static String INCOMING_TERMINATION_STRING = "\\r";
    public static String REG_OUTGOING_TERMINATION_STRING = "/OutgoingTerminationString";
    private static final String OUTGOING_TERMINATION_STRING_DEFAULT = "\\r";
    public static String OUTGOING_TERMINATION_STRING = "\\r";
    public static String REG_SEND_COUNTS = "/SendCounts";
    private static final boolean SEND_COUNTS_DEFAULT = false;
    public static boolean SEND_COUNTS = false;
    public static String REG_INPUT_NOTIFY = "/SendCounts";
    private static final String INPUT_NOTIFY_DEFAULT = "IN XX";
    public static String INPUT_NOTIFY = "IN XX";
    public static String REG_OUTPUT_NOTIFY = "/SendCounts";
    private static final String OUTPUT_NOTIFY_DEFAULT = "OUT XX";
    public static String OUTPUT_NOTIFY = "OUT XX";
    private TcpServer m_tcpServer = null;
    private SerialPort serial;
    private SerialParams sp;
    private Thread m_serialThd;
    private InputStream spin;
    private OutputStream spout;
    private IOStateMonitor stateMonitor;

    public SCLMain(String string) {
        super(APP_NAME, VERSION, string);
        try {
            System.out.println(this.name);
            try {
                this.printInfo("Open and Configure Port");
                this.sp = new SerialParams("AppData/" + this.name.replace(' ', '_'));
                this.sp.configPort();
                this.serial = this.sp.openPort(this.name);
            }
            catch (Exception exception) {
                JANOS.syslog((String)"Serial Control:\r\n                         There was a problem with the configuration of the serial port.\r\n                         Fix the configuration, and Reboot.");
                SCLMain.ExitException("Serial Control:\r\n                         There was a problem with the configuration of the serial port.\r\n                         Fix the configuration, and Reboot.");
                return;
            }
            if (this.serial != null) {
                this.printInfo("Retreive I/O Streams");
                this.spin = this.serial.getInputStream();
                this.spout = this.serial.getOutputStream();
            }
            this.printInfo("Retreive Other Configuration");
            REG_SEND_COUNTS = "AppData/" + APP_NAME.replace(' ', '_') + REG_SEND_COUNTS;
            SEND_COUNTS = JANOS.getRegistryBoolean((String)REG_SEND_COUNTS, (boolean)SEND_COUNTS);
            if (!SEND_COUNTS) {
                JANOS.setRegistryString((String)REG_SEND_COUNTS, (String)String.valueOf(SEND_COUNTS));
            }
            INCOMING_TERMINATION_STRING = this.getTerminationString(REG_INCOMING_TERMINATION_STRING, "\\r");
            String string2 = JANOS.getRegistryString((String)("AppData/" + APP_NAME.replace(' ', '_') + "/TerminationString"), (String)"");
            if (!string2.equals("")) {
                JANOS.setRegistryString((String)("AppData/" + APP_NAME.replace(' ', '_') + "/TerminationString"), (String)"");
                JANOS.setRegistryString((String)("AppData/" + APP_NAME.replace(' ', '_') + REG_OUTGOING_TERMINATION_STRING), (String)string2);
            }
            OUTGOING_TERMINATION_STRING = this.getTerminationString(REG_OUTGOING_TERMINATION_STRING, "\\r");
            this.printInfo("Create State Monitor");
            MessagePump messagePump = new MessagePump();
            this.stateMonitor = new IOStateMonitor(messagePump);
            this.stateMonitor.start();
            if (this.serial != null) {
                this.printInfo("Create Serial Reader");
                this.m_serialThd = new Thread(new CommandHandler(this.spin, this.spout));
                this.m_serialThd.start();
            }
            this.m_tcpServer = new TcpServer(this);
            this.waitForUserInput();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    private String getTerminationString(String string, String string2) throws IOException {
        string = "AppData/" + APP_NAME.replace(' ', '_') + string;
        String string3 = JANOS.getRegistryString((String)string, (String)string2);
        if (string3.equals(string2)) {
            JANOS.setRegistryString((String)string, (String)string2);
        }
        String string4 = "";
        boolean bl = false;
        for (int i = 0; i < string3.length(); ++i) {
            if (string3.charAt(i) == '\\' && !bl) {
                bl = true;
                continue;
            }
            if (bl) {
                switch (string3.charAt(i)) {
                    case 'r': {
                        string4 = string4 + '\r';
                        break;
                    }
                    case 'n': {
                        string4 = string4 + '\n';
                        break;
                    }
                    case 't': {
                        string4 = string4 + '\r';
                        break;
                    }
                    case 'f': {
                        string4 = string4 + '\f';
                        break;
                    }
                    case 'b': {
                        string4 = string4 + '\b';
                        break;
                    }
                    case '0': {
                        string4 = string4 + '\u0000';
                    }
                }
            } else {
                string4 = string4 + string3.charAt(i);
            }
            bl = false;
        }
        return string4;
    }

    public void stopApp() {
        super.stopApp();
        try {
            this.printInfo("Stopping TCP Server");
            this.m_tcpServer.stop();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.printInfo("Stopping State Monitor");
        this.stateMonitor.stop();
        System.gc();
    }

    public void addStateListener(IOStateListener iOStateListener, int n, int n2) {
        this.stateMonitor.addStateListener(iOStateListener, n, n2);
    }

    public void removeStateListener(IOStateListener iOStateListener, int n, int n2) {
        this.stateMonitor.removeStateListener(iOStateListener, n, n2);
    }

    public static void main(String[] stringArray) {
        String string = "";
        if (stringArray != null && stringArray.length > 0) {
            try {
                string = stringArray[0];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        new SCLMain(string);
    }

    public void onUserInput(int n) {
    }

    private class SerialReader {
        private Thread m_thd;

        private SerialReader(int n) {
            this.m_thd = new Thread(new CommandHandler(SCLMain.this.spin, SCLMain.this.spout));
            this.m_thd.start();
        }
    }
}

