/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integpg.janoslib.datastructures.BPlusTree;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.debug.Stopwatch;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.snmp.SNMPJanosInputs;
import com.integpg.snmp.SNMPJanosOutputs;
import com.integpg.snmp.SNMPJanosUptime;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPVariablePair;
import com.integpg.snmp.objects.exceptions.SNMPBadValueException;
import com.integpg.system.JANOS;
import java.net.InetAddress;
import java.util.Hashtable;

public class SNMPStore {
    public static final String MGMT_SYSTEM = "1.3.6.1.2.1.1";
    public static final String INTEG_PEN = "1.3.6.1.4.1.31976";
    public static final String JNIOR_IO = "1.3.6.1.4.1.31976.1.1";
    public static final String INPUT_MASK = "1.3.6.1.4.1.31976.1.1.1.0";
    public static final String INPUTS = "1.3.6.1.4.1.31976.1.1.2";
    public static final String OUTPUT_MASK = "1.3.6.1.4.1.31976.1.1.3.0";
    public static final String OUTPUTS = "1.3.6.1.4.1.31976.1.1.4";
    public static final String EXTERNALS = "1.3.6.1.4.1.31976.1.1.5.";
    public static final String JNIOR_INFO_TRAP = "1.3.6.1.4.1.31976.1.0.1";
    public static final String JNIOR_INFORMATION = "1.3.6.1.4.1.31976.1.2";
    public static final String SERIAL_NUMBER = "1.3.6.1.4.1.31976.1.2.1.0";
    public static SNMPJanosUptime SYSTEM_UPTIME = new SNMPJanosUptime();
    public static SNMPJanosInputs SYSTEM_INPUT_MASK = new SNMPJanosInputs();
    public static SNMPJanosInputs[] SYSTEM_INPUTS = new SNMPJanosInputs[12];
    public static SNMPJanosOutputs SYSTEM_OUTPUT_MASK = new SNMPJanosOutputs();
    public static SNMPJanosOutputs[] SYSTEM_OUTPUTS = new SNMPJanosOutputs[16];
    public static BPlusTree _oidTree = new BPlusTree(8);
    private static Hashtable<String, SNMPObjectIdentifier> oidCache = new Hashtable();

    public static void init() {
        try {
            int i;
            JANOS.setRegistryString((String)"SNMP/IntegPrivateEnterpriseOID", (String)INTEG_PEN);
            AppLog.info("initializing oid store");
            Stopwatch stopwatch = new Stopwatch("init");
            stopwatch.start();
            String description = JANOS.getSerialNumber() + "; JNIOR OS " + JANOS.getVersion();
            SNMPStore.insertPair("1.3.6.1.2.1.1.1.0", (SNMPObject)new SNMPOctetString(description));
            stopwatch.split("insert description");
            SNMPStore.insertPair("1.3.6.1.2.1.1.2.0", (SNMPObject)new SNMPObjectIdentifier(INTEG_PEN));
            stopwatch.split("insert oid");
            SNMPStore.insertPair("1.3.6.1.2.1.1.3.0", (SNMPObject)SYSTEM_UPTIME);
            stopwatch.split("insert uptime");
            SNMPStore.insertPair("1.3.6.1.2.1.1.4.0", (SNMPObject)new SNMPOctetString("INTEG Process Group, inc. (www.integpg.com)"));
            stopwatch.split("insert contact");
            SNMPStore.insertPair("1.3.6.1.2.1.1.5.0", (SNMPObject)new SNMPOctetString(InetAddress.getLocalHost().getHostName()));
            stopwatch.split("insert hostname");
            SNMPStore.insertPair("1.3.6.1.2.1.1.6.0", (SNMPObject)new SNMPOctetString("Unknown"));
            stopwatch.split("insert location");
            SNMPStore.insertPair(SERIAL_NUMBER, (SNMPObject)new SNMPInteger(JANOS.getSerialNumber()));
            stopwatch.split("insert serial");
            SNMPStore.insertPair(INPUT_MASK, (SNMPObject)SYSTEM_INPUT_MASK);
            stopwatch.split("insert inputmask");
            for (i = 1; i <= UnitConfig.getInputCount(); ++i) {
                SNMPStore.SYSTEM_INPUTS[i - 1] = new SNMPJanosInputs(i - 1);
                SNMPStore.insertPair("1.3.6.1.4.1.31976.1.1.2.1.1." + i, (SNMPObject)new SNMPInteger(i));
                SNMPStore.insertPair("1.3.6.1.4.1.31976.1.1.2.1.2." + i, (SNMPObject)SYSTEM_INPUTS[i - 1]);
                stopwatch.split("insert input " + i);
            }
            SNMPStore.insertPair(OUTPUT_MASK, (SNMPObject)SYSTEM_OUTPUT_MASK);
            stopwatch.split("insert outputmask");
            for (i = 1; i <= UnitConfig.getOutputCount(); ++i) {
                SNMPStore.SYSTEM_OUTPUTS[i - 1] = new SNMPJanosOutputs(i - 1);
                SNMPStore.insertPair("1.3.6.1.4.1.31976.1.1.4.1.1." + i, (SNMPObject)new SNMPInteger(i));
                SNMPStore.insertPair("1.3.6.1.4.1.31976.1.1.4.1.2." + i, (SNMPObject)SYSTEM_OUTPUTS[i - 1]);
                stopwatch.split("insert output " + i);
            }
            if (DEBUG.ON) {
                SNMPStore.dump();
                stopwatch.split("print tree");
            }
            stopwatch.stop();
            System.out.println(stopwatch);
            AppLog.info("oid store initialized");
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
    }

    public static SNMPVariablePair insertPair(String id, SNMPObject value) {
        try {
            SNMPObjectIdentifier objectID = null;
            if (oidCache.containsKey(id)) {
                objectID = oidCache.get(id);
            } else {
                objectID = new SNMPObjectIdentifier(id);
                oidCache.put(id, objectID);
            }
            return SNMPStore.insertPair(objectID, value);
        }
        catch (Exception ex) {
            AppLog.error(ex);
            return null;
        }
    }

    public static SNMPVariablePair insertPair(SNMPObjectIdentifier objectID, SNMPObject value) {
        try {
            SNMPVariablePair pair = new SNMPVariablePair(objectID, value);
            _oidTree.insert(objectID, pair);
            return pair;
        }
        catch (Exception ex) {
            AppLog.error(ex);
            return null;
        }
    }

    public static SNMPVariablePair findPair(String id) throws SNMPBadValueException {
        return SNMPStore.findPair(new SNMPObjectIdentifier(id));
    }

    public static SNMPVariablePair findPair(SNMPObjectIdentifier oid) throws SNMPBadValueException {
        return (SNMPVariablePair)_oidTree.find(oid);
    }

    public static SNMPVariablePair findNextPair(String id) throws SNMPBadValueException {
        return SNMPStore.findNextPair(new SNMPObjectIdentifier(id));
    }

    static SNMPVariablePair findNextPair(SNMPObjectIdentifier oid) throws SNMPBadValueException {
        return (SNMPVariablePair)_oidTree.findNext(oid);
    }

    public static void dump() {
        _oidTree.dump();
    }
}

