/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Helpers.Dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginDialog
extends JDialog {
    private String CMD_CANCEL = "cmd.cancel";
    private String CMD_HELP = "cmd.help";
    private String CMD_LOGIN = "cmd.login";
    public static final int RET_CANCEL = 0;
    public static final int RET_LOGIN = 1;
    private int result = 0;
    private JTextField userNameTextField = null;
    private JPasswordField passwordField = null;
    private JButton loginButton = null;
    private static final Object sharedFrameKey = LoginDialog.class;

    public LoginDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.pack();
    }

    public LoginDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.pack();
    }

    public int getResult() {
        return this.result;
    }

    public String getUsername() {
        return this.userNameTextField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public void centerParent() {
        Container container = this.getParent();
        Point point = container.getLocationOnScreen();
        Dimension dimension = container.getSize();
        Dimension dimension2 = this.getSize();
        int n = dimension.width > dimension2.width ? (dimension.width - dimension2.width) / 2 + point.x : point.x;
        int n2 = dimension.height > dimension2.height ? (dimension.height - dimension2.height) / 2 + point.y : point.y;
        this.setLocation(n, n2);
        this.requestFocus();
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = null;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.setTitle("Login");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoginDialog.this.windowAction(LoginDialog.this.CMD_CANCEL);
            }
        });
        this.userNameTextField = new JTextField();
        JLabel jLabel = new JLabel();
        jLabel.setDisplayedMnemonic('U');
        jLabel.setLabelFor(this.userNameTextField);
        jLabel.setText("User Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        container.add((Component)jLabel, gridBagConstraints);
        this.userNameTextField.setToolTipText("Enter User Name Here");
        this.userNameTextField.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(12, 7, 0, 11);
        container.add((Component)this.userNameTextField, gridBagConstraints);
        this.passwordField = new JPasswordField();
        JLabel jLabel2 = new JLabel();
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setText("Password");
        jLabel2.setLabelFor(this.passwordField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        container.add((Component)jLabel2, gridBagConstraints);
        this.passwordField.setToolTipText("Enter Password Here");
        this.passwordField.setPreferredSize(new Dimension(150, 19));
        this.passwordField.setEchoChar('\u2022');
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 7, 0, 11);
        container.add((Component)this.passwordField, gridBagConstraints);
        JPanel jPanel = this.createButtonPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(17, 12, 11, 11);
        container.add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.loginButton);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.loginButton = new JButton();
        this.loginButton.setText("Login");
        this.loginButton.setToolTipText("Click to Login");
        this.loginButton.setActionCommand(this.CMD_LOGIN);
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.windowAction(actionEvent);
            }
        });
        jPanel.add(this.loginButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton = new JButton();
        jButton.setText("Cancel");
        jButton.setActionCommand(this.CMD_CANCEL);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.windowAction(actionEvent);
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        Vector<JButton> vector = new Vector<JButton>(2);
        vector.add(this.loginButton);
        vector.add(jButton);
        this.equalizeComponentSizes(vector);
        vector.removeAllElements();
        return jPanel;
    }

    private void equalizeComponentSizes(List list) {
        int n = 0;
        Dimension dimension = new Dimension(0, 0);
        JComponent jComponent = null;
        Dimension dimension2 = null;
        for (n = 0; n < list.size(); ++n) {
            jComponent = (JComponent)list.get(n);
            dimension2 = jComponent.getPreferredSize();
            dimension.width = Math.max(dimension.width, (int)dimension2.getWidth());
            dimension.height = Math.max(dimension.height, (int)dimension2.getHeight());
        }
        for (n = 0; n < list.size(); ++n) {
            jComponent = (JComponent)list.get(n);
            jComponent.setPreferredSize((Dimension)dimension.clone());
            jComponent.setMaximumSize((Dimension)dimension.clone());
        }
    }

    private void windowAction(Object object) {
        String string = null;
        if (object != null) {
            string = object instanceof ActionEvent ? ((ActionEvent)object).getActionCommand() : object.toString();
        }
        if (string != null) {
            if (string.equals(this.CMD_CANCEL)) {
                this.result = 0;
            } else if (string.equals(this.CMD_LOGIN)) {
                this.result = 1;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 100);
            }
        };
        jFrame.setTitle("Debugging frame");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(false);
        LoginDialog loginDialog = new LoginDialog((Frame)jFrame, true);
        loginDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        loginDialog.pack();
        loginDialog.setVisible(true);
    }
}

