/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Devices.Externals;

import JniorProtocol.Devices.Externals.ExternalAnalog;
import JniorProtocol.JniorSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ExternalTypeF9
extends ExternalAnalog {
    public ExternalTypeF9(JniorSession jniorSession, long l) {
        super(jniorSession, l);
        this.m_description = "3 Channel Dimmer Module";
        this.m_out = new double[3];
        this.m_newOut = new double[3];
        this.m_unit = new String[]{"", "", ""};
        this.m_min = new int[]{0, 0, 0};
        this.m_max = new int[]{65520, 65520, 65520};
    }

    public double getOut(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        double d = this.m_out[--n];
        double d2 = this.m_out[n] / 65520.0;
        d = (double)(this.m_max[n] - this.m_min[n]) * d2 + (double)this.m_min[n];
        return d;
    }

    public void setOut(int n, int n2) {
        this.setOut(n, (double)n2);
    }

    public void setOut(int n, double d) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Channel Out of Range.");
        }
        if (d < 0.0 || d > 100.0) {
            throw new IllegalArgumentException("Value Out of Range.");
        }
        this.m_newOut[--n] = 65520.0 * d / 100.0;
    }

    public byte[] getWriteBytes() {
        byte[] byArray = new byte[16];
        ExternalTypeF9.setShort(byArray, 0, (short)(this.m_newOut[0] + 1.0));
        ExternalTypeF9.setShort(byArray, 2, (short)(this.m_newOut[1] + 1.0));
        ExternalTypeF9.setShort(byArray, 4, (short)(this.m_newOut[2] + 1.0));
        return byArray;
    }

    public void receive(ByteArrayInputStream byteArrayInputStream) {
        try {
            this.m_newOut[0] = this.m_out[0] = (double)ExternalTypeF9.getShort(byteArrayInputStream);
            this.m_newOut[1] = this.m_out[1] = (double)ExternalTypeF9.getShort(byteArrayInputStream);
            this.m_newOut[2] = this.m_out[2] = (double)ExternalTypeF9.getShort(byteArrayInputStream);
            byteArrayInputStream.skip(10L);
            this.fireStateChange();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String toString() {
        String string = this.m_hexAddress + " : " + this.m_description + " : ";
        for (int i = 0; i < 3; ++i) {
            string = string + ", ";
            string = string + this.getOut(i + 1) + this.m_unit[i + 4];
        }
        return string;
    }
}

