/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.ExternalTemperatureModule;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;

public class Type7E
extends ExternalModule
implements ExternalTemperatureModule {
    private static final int START_ADDR = 32;
    private static final int LENGTH = 32;
    private final byte[] _data;
    private double _tempC = Double.NaN;
    private double _tempF = Double.NaN;
    private double _heatIndexC = Double.NaN;
    private double _heatIndexF = Double.NaN;
    private double _dewPointC = Double.NaN;
    private double _dewPointF = Double.NaN;
    private double _humidity = Double.NaN;
    private double _pressureMillibars = Double.NaN;
    private double _pressureInHg = Double.NaN;
    private int _lightLux = -1;
    private boolean _lastReadResult = true;
    public boolean Updated = false;
    private static final byte[] _initData = new byte[32];

    public static Type7E getByIndex(int index) {
        String typeString = "Type7E_" + (index + 1);
        String addressString = JANOS.getRegistryString((String)("externals/deviceorder/" + typeString), null);
        if (null != addressString) {
            if (!ModulesByAddress.containsKey(addressString)) {
                long address = HexUtils.parseHexAsLong(addressString);
                Type7E type7E = new Type7E(address);
                type7E.TypeIndex = index + 1;
                type7E.TypeString = typeString;
                ModulesByAddress.put(addressString, type7E);
            }
            return (Type7E)ModulesByAddress.get(addressString);
        }
        return null;
    }

    public Type7E(long address) {
        super(address);
        this._data = new byte[30];
    }

    @Override
    public long getMinReadInterval() {
        return 1000L;
    }

    public boolean getLastReadResult() {
        return this._lastReadResult;
    }

    @Override
    public double getTempC() {
        return this._tempC;
    }

    @Override
    public double getTempF() {
        return this._tempF;
    }

    public double getHeatIndexF() {
        return this._heatIndexF;
    }

    public double getHumidity() {
        return this._humidity;
    }

    public double getPressureInHg() {
        return this._pressureInHg;
    }

    public double getLightLux() {
        return this._lightLux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IOException {
        byte[] data = new byte[35];
        int id = -1;
        data[0] = -16;
        data[1] = 32;
        data[2] = 0;
        ArrayUtils.arraycopy((Object)_initData, (int)0, (Object)data, (int)3, (int)32);
        SensorPort sensorPort = SENSOR_PORT;
        synchronized (sensorPort) {
            try {
                SENSOR_PORT.open();
                SENSOR_PORT.select(this.Address);
                SENSOR_PORT.data(data, 0, data.length);
                System.out.println("_lastReadResult: " + this._lastReadResult);
            }
            catch (Exception ex) {
                this._lastReadResult = false;
                AppLog.error(ex);
            }
            finally {
                try {
                    SENSOR_PORT.close();
                }
                catch (Exception ex) {}
            }
            this.LastReadTime = System.currentTimeMillis();
            id = data[3] & 0xFF;
            if (255 == id) {
                this.Updated = this._lastReadResult;
                this._lastReadResult = false;
            } else {
                this._lastReadResult = true;
            }
            this.Updated = !ArrayUtils.arrayComp((Object)data, (int)5, (Object)this._data, (int)0, (int)30);
            ArrayUtils.arraycopy((Object)data, (int)5, (Object)this._data, (int)0, (int)30);
        }
        if (this.Updated) {
            this._tempC = this.getValue(0, 2);
            this._tempC = -2.147483648E9 != this._tempC ? (this._tempC /= 16.0) : Double.NaN;
            if (-20.0 > this._tempC || 85.0 < this._tempC) {
                throw new RuntimeException("celcius temperature out of range: " + this._tempC);
            }
            this._tempF = -2.147483648E9 != this._tempC ? this._tempC * 9.0 / 5.0 + 32.0 : Double.NaN;
            if (101 == id || 104 == id) {
                double humidity = this.getValue(2, 2);
                humidity = -2.147483648E9 != humidity ? (humidity /= 16.0) : Double.NaN;
                this._humidity = humidity;
                this._dewPointC = (short)this.getValue(4, 2);
                this._dewPointC = -2.147483648E9 != this._dewPointC ? (this._dewPointC /= 16.0) : Double.NaN;
                this._dewPointF = -2.147483648E9 != this._dewPointC ? this._dewPointC * 9.0 / 5.0 + 32.0 : Double.NaN;
                double humIndexC = this.getValue(6, 2);
                humIndexC = -2.147483648E9 != humIndexC ? (humIndexC /= 16.0) : Double.NaN;
                this._heatIndexC = this.getValue(8, 2);
                if (-2.147483648E9 != this._heatIndexC) {
                    this._heatIndexC /= 16.0;
                }
                this._heatIndexF = this._heatIndexC;
                if (-2.147483648E9 != this._heatIndexC) {
                    this._heatIndexF = this._heatIndexC * 9.0 / 5.0 + 32.0;
                }
            }
            if (102 == id || 104 == id) {
                this._pressureMillibars = (double)this.getValue(10, 3) / 2048.0;
                this._pressureInHg = this.getValue(13, 3);
                if (-2.147483648E9 != this._pressureInHg) {
                    this._pressureInHg /= 2048.0;
                }
            }
            if (103 == id || 104 == id) {
                this._lightLux = this.getValue(16, 3);
            }
            if (null != this.TypeString && RegistryHelper.getRegistryKey("Externals/" + this.TypeString + "/UpdateRegistryWithValues", false)) {
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$TempC"), (String)String.valueOf(this._tempC));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$TempF"), (String)String.valueOf(this._tempF));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$Humidity"), (String)String.valueOf(this._humidity));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$LastReadTime"), (String)QUICK_DATE_FORMAT.format(System.currentTimeMillis()));
            }
        }
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void printValues() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private int getValue(int idx, int len) {
        int value = 0;
        boolean invalid = true;
        while (len-- > 0) {
            value <<= 8;
            int b = this._data[idx + len] & 0xFF;
            invalid &= b == 255;
            value += b;
        }
        if (invalid) {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    @Override
    public Object get(String fieldName) {
        if (!this._lastReadResult) {
            return Double.NaN;
        }
        if (0 == this.TypeIndex) {
            throw new RuntimeException("Module must have an index");
        }
        if ("tempf".equalsIgnoreCase(fieldName)) {
            return this.getTempF();
        }
        if ("tempc".equalsIgnoreCase(fieldName)) {
            return this.getTempC();
        }
        if ("humidity".equalsIgnoreCase(fieldName)) {
            return this.getHumidity();
        }
        if ("heatindexf".equalsIgnoreCase(fieldName)) {
            return this.getHeatIndexF();
        }
        if ("pressurehg".equalsIgnoreCase(fieldName)) {
            return this.getPressureInHg();
        }
        if ("lux".equalsIgnoreCase(fieldName)) {
            return this.getLightLux();
        }
        throw new RuntimeException("Invalid Field Name: " + fieldName);
    }

    static {
        for (int n = 0; n < 32; ++n) {
            Type7E._initData[n] = -1;
        }
    }
}

