/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integ.janoslib.messagepump.MessagePumpListener;
import com.integpg.snmp.TrapSender;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPNull;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.system.SystemMsg;
import java.util.Json;

public class TrapReceiveHandler
implements MessagePumpListener {
    private final TrapSender _trapSender;

    public TrapReceiveHandler(TrapSender trapSender) {
        this._trapSender = trapSender;
    }

    @Override
    public void messageReceived(SystemMsg msg) {
        if (3001 == msg.type) {
            String communityName;
            Json json = new Json(new String(msg.msg));
            System.out.println("msg: " + msg.type + " = " + json);
            String host = null;
            int port = -1;
            if (json.containsKey("host")) {
                host = json.getString("host");
            }
            if (json.containsKey("port")) {
                port = json.getInt("port");
            }
            if (null == (communityName = json.getString("community-name"))) {
                communityName = "public";
            }
            String id = json.getString("oid");
            String type = json.getString("type");
            String value = json.getString("value");
            SNMPObject object = new SNMPNull();
            if ("string".equalsIgnoreCase(type)) {
                object = new SNMPOctetString(value);
            } else if ("integer".equalsIgnoreCase(type)) {
                object = new SNMPInteger(Integer.parseInt(value));
            }
            SNMPObjectIdentifier oid = new SNMPObjectIdentifier(id);
            if (null != host) {
                if (-1 != port) {
                    this._trapSender.sendTrap(oid, object, host, port, communityName);
                } else {
                    this._trapSender.sendTrap(oid, object, host, communityName);
                }
            } else {
                this._trapSender.sendTrap(oid, object, communityName);
            }
        }
    }
}

