/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager;

import com.integpg.EmbeddedHelpers.Monitor.IOStateListener;
import com.integpg.EmbeddedHelpers.Monitor.IOStateMonitor;
import com.integpg.TaskManager.Event.Event;
import com.integpg.TaskManager.Event.EventData;
import com.integpg.TaskManager.TaskManager;
import java.io.IOException;

public class LogicalWatcher
implements IOStateListener {
    private long _inputStates;
    private long _outputStates;
    private EventData _eventData;

    public LogicalWatcher(EventData ed) {
        try {
            int channel;
            this._eventData = ed;
            System.out.println("init io states");
            this._inputStates = TaskManager.getInstance().m_jnioros.getInputStates();
            this._outputStates = TaskManager.getInstance().m_jnioros.getOutputStates();
            System.out.println("used inputs: " + this._eventData._logic.getInputsUsedMask());
            for (channel = 0; channel < 12; ++channel) {
                if ((this._eventData._logic.getInputsUsedMask() >> channel & 1) != 1) continue;
                IOStateMonitor.getInstance().addStateListener(this, 0, channel + 1);
            }
            System.out.println("used outputs: " + this._eventData._logic.getOutputsUsedMask());
            for (channel = 0; channel < 16; ++channel) {
                if ((this._eventData._logic.getOutputsUsedMask() >> channel & 1) != 1) continue;
                IOStateMonitor.getInstance().addStateListener(this, 1, channel + 1);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void ioStateChange(int io, byte channel, byte state, long inputMask, long outputMask) {
        System.out.println("IO Change " + inputMask + " " + outputMask);
        if ((inputMask != this._inputStates || outputMask != this._outputStates) && this._eventData._logic != null) {
            int result = this._eventData._logic.evaluate(inputMask, outputMask);
            System.out.println("eval logic: " + result);
            if (result == 1) {
                new Event(TaskManager.getInstance()).doEvent(this._eventData);
            }
        }
        this._inputStates = inputMask;
        this._outputStates = outputMask;
    }

    public void finalize() {
        int channel;
        System.out.println("used inputs: " + this._eventData._logic.getInputsUsedMask());
        for (channel = 0; channel < 12; ++channel) {
            if ((this._eventData._logic.getInputsUsedMask() >> channel & 1) != 1) continue;
            IOStateMonitor.getInstance().removeStateListener(this, 0, channel + 1);
        }
        System.out.println("used outputs: " + this._eventData._logic.getOutputsUsedMask());
        for (channel = 0; channel < 16; ++channel) {
            if ((this._eventData._logic.getOutputsUsedMask() >> channel & 1) != 1) continue;
            IOStateMonitor.getInstance().removeStateListener(this, 1, channel + 1);
        }
    }
}

