/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.slaveservice;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.messaging.MessageLoop;
import com.integpg.janoslib.messaging.RegistryMessageListener;
import com.integpg.janoslib.system.Application;
import com.integpg.slaveservice.AssemblyInfo;
import com.integpg.slaveservice.LocalSlaveService;
import com.integpg.slaveservice.RemoteSlaveService;
import com.integpg.slaveservice.SlaveConfigInfo;
import com.integpg.slaveservice.SlaveService;
import com.integpg.system.JANOS;
import java.util.Hashtable;

public class SlaveServiceMain
implements RegistryMessageListener {
    private final Hashtable _slaveServices = new Hashtable();
    private final SlaveConfigInfo[] _channelConfig = new SlaveConfigInfo[16];

    public void main(String[] args) {
        try {
            Application.init(new AssemblyInfo());
            Application.enableApplicationWatchdog(4);
            SlaveServiceMain ssm = new SlaveServiceMain();
            ssm.init();
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    private void init() {
        this._slaveServices.put("localhost", new LocalSlaveService());
        this.setupMessageLoopListeners();
        this.loadInititalRegistryConfig();
        Application.sleepForever();
    }

    private void setupMessageLoopListeners() {
        MessageLoop.addRegistryListener(this);
    }

    @Override
    public void registryMessageReceived(String registryKey) {
        try {
            if (this.isSlavingKey(registryKey)) {
                this.processSlaveKey(registryKey);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Error processing registry key change", ex);
        }
    }

    private void loadInititalRegistryConfig() {
        for (int i = 0; i < 16; ++i) {
            String key = "IO/Outputs/rout" + (i + 1) + "/Slave";
            this.processSlaveKey(key);
        }
    }

    private boolean isSlavingKey(String registryKey) {
        return registryKey.endsWith("Slave");
    }

    private void processSlaveKey(String registryKey) {
        System.out.println("Process: " + registryKey);
        int channel = this.getChannelFromSlaveKey(registryKey);
        SlaveConfigInfo slaveConfigInfo = this.getSlaveConfigInfo(registryKey);
        this.checkConfigChange(channel, slaveConfigInfo);
        if (slaveConfigInfo != null) {
            AppLog.info("Load slaving configuration for channel " + channel + ": " + slaveConfigInfo.toString());
            this._channelConfig[channel - 1] = slaveConfigInfo;
            if (!this._slaveServices.containsKey(slaveConfigInfo.IPAddress)) {
                RemoteSlaveService rss = this.createRemoteSlaveService(slaveConfigInfo.IPAddress, slaveConfigInfo.Port, slaveConfigInfo.Username, slaveConfigInfo.Password);
                this._slaveServices.put(slaveConfigInfo.IPAddress, rss);
            }
            SlaveService slaveService = (SlaveService)this._slaveServices.get(slaveConfigInfo.IPAddress);
            if (slaveConfigInfo.IOPoint.startsWith("din")) {
                int inputChannel = Integer.parseInt(slaveConfigInfo.IOPoint.substring(3));
                slaveService.followInput(inputChannel, channel);
            } else if (slaveConfigInfo.IOPoint.startsWith("rout")) {
                int outputChannel = Integer.parseInt(slaveConfigInfo.IOPoint.substring(4));
                slaveService.followOutput(outputChannel, channel);
            }
            slaveService.setFailedCommOutputState(channel, slaveConfigInfo.FailedCommString);
        }
    }

    private int getChannelFromSlaveKey(String slaveRegistryKey) {
        int routPos = slaveRegistryKey.indexOf("rout");
        if (routPos == -1) {
            throw new RuntimeException("Not a slaving registry key");
        }
        int nextForewardSlashPos = slaveRegistryKey.indexOf("/", routPos);
        int channel = Integer.parseInt(slaveRegistryKey.substring(routPos + 4, nextForewardSlashPos));
        return channel;
    }

    private SlaveConfigInfo getSlaveConfigInfo(String slaveRegistryKey) {
        String value = JANOS.getRegistryString((String)slaveRegistryKey, (String)"");
        if ("".equals(value)) {
            return null;
        }
        return new SlaveConfigInfo(value);
    }

    private void checkConfigChange(int channel, SlaveConfigInfo slaveConfigInfo) {
        if (this._channelConfig[channel - 1] != null) {
            if (slaveConfigInfo == null || slaveConfigInfo.compareTo(this._channelConfig[channel - 1]) != 0) {
                System.out.println("Config changed");
                AppLog.info("Remove slaving config for channel " + channel + ": " + this._channelConfig[channel - 1].toString());
                SlaveService slaveService = (SlaveService)this._slaveServices.get(this._channelConfig[channel - 1].IPAddress);
                if (this._channelConfig[channel - 1].IOPoint.startsWith("din")) {
                    int inputChannel = Integer.parseInt(this._channelConfig[channel - 1].IOPoint.substring(3));
                    slaveService.unfollowInput(inputChannel, channel);
                } else if (this._channelConfig[channel - 1].IOPoint.startsWith("rout")) {
                    int outputChannel = Integer.parseInt(this._channelConfig[channel - 1].IOPoint.substring(4));
                    slaveService.unfollowOutput(outputChannel, channel);
                }
            }
        } else {
            System.out.println("No previous config for " + channel);
        }
    }

    private RemoteSlaveService createRemoteSlaveService(String ipAddress, int port, String username, String password) {
        RemoteSlaveService rss = new RemoteSlaveService(ipAddress, port, username, password);
        return rss;
    }
}

