/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.EmbeddedHelpers.InterProcess;

import com.dalsemi.system.ArrayUtils;
import com.integpg.EmbeddedHelpers.Immutable.BufferEntry;
import com.integpg.EmbeddedHelpers.InterProcess.InterProcessArgument;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;

public class InterProcessEntry
extends BufferEntry {
    public static final int IGNORE_POS = 0;
    public static final int SOURCE_POS = 1;
    public static final int DEST_POS = 5;
    public static final int COMMAND_NAME_LEN_POS = 9;
    public static final int COMMAND_NAME_POS = 10;
    public boolean m_ignored = false;
    public int m_source;
    public int m_dest;
    public String m_commandName;
    public int m_argumentCount;
    public InterProcessArgument[] m_arguments;

    public InterProcessEntry() {
    }

    public InterProcessEntry(int source, int dest) {
        this.m_source = source;
        this.m_dest = dest;
    }

    public void setData(String commandName, InterProcessArgument[] args) throws Exception {
        int dataSize = 11;
        dataSize += commandName.length();
        for (int i = 0; i < args.length; ++i) {
            dataSize += 3 + args[i].getLength();
        }
        byte[] bytes = new byte[dataSize];
        bytes[0] = 0;
        ArrayUtils.setInt(bytes, 1, this.m_source);
        ArrayUtils.setInt(bytes, 5, this.m_dest);
        int commandNameLength = commandName.length();
        this.m_commandName = commandName;
        bytes[9] = (byte)commandNameLength;
        int pos = 10;
        ArrayUtils.arraycopy(commandName.getBytes(), 0, bytes, pos, commandNameLength);
        pos += commandNameLength;
        this.m_argumentCount = args.length;
        bytes[pos++] = (byte)this.m_argumentCount;
        this.m_arguments = new InterProcessArgument[this.m_argumentCount];
        for (int i = 0; i < this.m_argumentCount; ++i) {
            this.m_arguments[i] = args[i];
            bytes[pos++] = args[i].getType();
            int len = args[i].getLength();
            ArrayUtils.setShort(bytes, pos, (short)len);
            ArrayUtils.arraycopy(args[i].getBytes(), 0, bytes, pos += 2, len);
            pos += len;
        }
        super.setData(bytes);
    }

    @Override
    public void parse(DataInputStream dis) throws EOFException, IOException {
        super.parse(dis);
        if (this.m_size == 0) {
            return;
        }
        int pos = 12;
        try {
            this.m_ignored = this.m_bytes[pos++] == 1;
            this.m_source = ArrayUtils.getInt(this.m_bytes, pos);
            this.m_dest = ArrayUtils.getInt(this.m_bytes, pos += 4);
            pos += 4;
            byte commandNameLength = this.m_bytes[pos++];
            this.m_commandName = new String(this.m_bytes, pos, (int)commandNameLength);
            pos += commandNameLength;
            this.m_argumentCount = this.m_bytes[pos++];
            this.m_arguments = new InterProcessArgument[this.m_argumentCount];
            for (int i = 0; i < this.m_argumentCount; ++i) {
                this.m_arguments[i] = new InterProcessArgument();
                this.m_arguments[i].parse(this.m_bytes, pos);
                pos += this.m_arguments[i].getLength() + 3;
            }
        }
        catch (Exception ex) {
            this.m_size = 0;
            System.out.println("Buffer Entry Parse " + this.m_bytes.length + " bytes");
            ex.printStackTrace();
        }
    }

    @Override
    public void parse(byte[] bytes) throws Exception {
        super.parse(bytes);
        if (this.m_size == 0) {
            return;
        }
        int pos = 12;
        try {
            this.m_ignored = bytes[pos++] == 1;
            this.m_source = ArrayUtils.getInt(bytes, pos);
            this.m_dest = ArrayUtils.getInt(bytes, pos += 4);
            pos += 4;
            byte commandNameLength = bytes[pos++];
            this.m_commandName = new String(bytes, pos, (int)commandNameLength);
            pos += commandNameLength;
            this.m_argumentCount = bytes[pos++];
            this.m_arguments = new InterProcessArgument[this.m_argumentCount];
            for (int i = 0; i < this.m_argumentCount; ++i) {
                this.m_arguments[i] = new InterProcessArgument();
                this.m_arguments[i].parse(bytes, pos);
                pos += this.m_arguments[i].getLength() + 3;
            }
        }
        catch (Exception ex) {
            this.m_size = 0;
            System.out.println("Buffer Entry Parse " + bytes.length + " bytes");
            ex.printStackTrace();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("InterProcessCommEntry - [");
        sb.append("From=");
        sb.append(this.m_source);
        sb.append(",To=");
        sb.append(this.m_dest);
        sb.append(",Address=0x");
        sb.append(Long.toHexString(this.m_immutableBufferAddress + 65536).substring(1));
        sb.append(",CommandName=");
        sb.append(this.m_commandName);
        sb.append(",ArgumentCount=");
        sb.append(this.m_argumentCount);
        sb.append(",Arguments={");
        for (int i = 0; i < this.m_argumentCount; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.m_arguments[i].getValue().toString());
        }
        sb.append("}]");
        return sb.toString();
    }
}

