var app = angular.module('slavingApp', []);


app.controller('slavingCtrl', function ($scope) {
    $scope.Config = {};
    $scope.Config.ioPoints = [];
    $scope.Config.outputs = [];

    $scope.SavedConfig = {};



    var loginDialog;
    var firstMonitor = true;
    var comm = new Comm();
    comm.connect();
    comm.onauth = function () {
        loginDialog = bootbox.dialog({
            closeButton: false,
            title: "Please enter your user credentials",
            message: '<form role="form">' +
                '    <div class="modal-body">' +
                '        <div class="form-group">' +
                '            <label for="login-username">Username</label>' +
                '            <input type="text" class="form-control" id="login-username" placeholder="Enter username" >' +
                '        </div>' +
                '        <div class="form-group">' +
                '            <label for="login-password">Password</label>' +
                '            <input type="password" class="form-control" id="login-password" placeholder="Enter password" >' +
                '        </div>' +
                '    </div>' +
                '</form>',
            buttons: {
                main: {
                    label: "Login",
                    className: "btn-primary",
                    callback: function () {
                        var username = $('#login-username').val();
                        var password = $('#login-password').val();
                        comm.authenticate(username, password);
                        return false;
                    }
                }
            }
        });
        loginDialog.attr('id', 'login-dialog');

        loginDialog.on("shown.bs.modal", function () {
            _loginSent = true;
            $('#login-username').focus();
        });

        loginDialog.keypress(function (e) {
            if (e.which == 13) {
                var username = $('#login-username').val();
                var password = $('#login-password').val();
                comm.authenticate(username, password);
            }
        });
    };
    comm.onmessage = function (evt) {
        var json = JSON.parse(evt.data);

        if (json.Message === "Authenticated") {
            loginDialog.modal('hide');
        } else if (json.Message === "Monitor") {
            if (firstMonitor) {
                for (var i = 0; i < json.Inputs.length; i++) {
                    $scope.Config.ioPoints.push("din" + (i + 1));
                }
                for (var i = 0; i < json.Outputs.length; i++) {
                    $scope.Config.ioPoints.push("rout" + (i + 1));
                    $scope.Config.outputs.push({ name: "rout" + (i + 1) });
                }

                readSlavingRegistryConfig();
                firstMonitor = false;

                $scope.$apply();
            }

        } else if (json.Message === "Registry Response"
            || json.Message === "Registry Update") {
            var keys = json.Keys;
            for (key in keys) {
                slaveInfoUpdate(key, keys[key]);
            }

            $scope.SavedConfig.inputs = angular.copy($scope.Config.inputs);
            $scope.SavedConfig.outputs = angular.copy($scope.Config.outputs);
            $scope.$apply();
        }
    };



    function readSlavingRegistryConfig() {
        var regRead = { "Message": "Registry Read", "Keys": [] };
        for (var i = 0; i < 8; i++) {
            regRead.Keys.push("/IO/Outputs/rout" + (i + 1) + "/Slave");
        }
        comm.sendJson(regRead);
    }
    ;



    function slaveInfoUpdate(key, slaveInfo) {
        if (slaveInfo) {
            console.log(slaveInfo);
            var regex = "IO/Outputs/rout([\\d]+)/Slave";
            var matches = key.match(regex);
            if (matches) {
                var channelIndex = matches[1] - 1;
                var slavingParts = slaveInfo.split(",");
                $scope.Config.outputs[channelIndex].ipAddress = slavingParts[0].trim();
                if ("" === $scope.Config.outputs[channelIndex].ipAddress) {
                    $scope.Config.outputs[channelIndex].ipAddress = "localhost";
                }
                $scope.Config.outputs[channelIndex].port = slavingParts[1].trim();
                $scope.Config.outputs[channelIndex].username = slavingParts[2].trim();
                $scope.Config.outputs[channelIndex].password = slavingParts[3].trim();
                $scope.Config.outputs[channelIndex].ioPoint = slavingParts[4].trim();
                if (5 < slavingParts.length) {
                    $scope.Config.outputs[channelIndex].failedComm = slavingParts[5].trim();
                }
            }
        }
    }



    $scope.save = function () {
        var message = 'Are you sure you want to save the changes you have made?';
        bootbox.confirm(message, function (result) {
            if (result) {
                var keys = {};
                for (var channelIndex = 0; channelIndex < $scope.Config.outputs.length; channelIndex++) {
                    var regKey = "IO/Outputs/rout" + (channelIndex + 1) + "/Slave";
                    var output = $scope.Config.outputs[channelIndex];
                    if (output.ioPoint && "" != output.ioPoint) {

                        if (!output.ipAddress)
                            output.ipAddress = "localhost";
                        var values = [output.ipAddress];
                        values.push(output.port ? output.port : "");
                        values.push(output.username ? output.username : "");
                        values.push(output.password ? output.password : "");
                        values.push(output.ioPoint ? output.ioPoint : "");
                        values.push(output.failedComm ? output.failedComm : "");

                        keys[regKey] = values.join(", ");
                    } else
                        keys[regKey] = "";
                }
                var regWrite = { "Message": "Registry Write", "Keys": keys };
                comm.sendJson(regWrite);

                setTimeout(function () {
                    readSlavingRegistryConfig();
                }, 1000);
            }
        });
    };



    $scope.revert = function () {
        var message = 'Are you sure you want to cancel the changes you have made?';
        bootbox.confirm(message, function (result) {
            if (result)
                readSlavingRegistryConfig();
        });
    };



    $scope.hasConfigChanged = function () {
        return !(angular.equals($scope.Config.inputs, $scope.SavedConfig.inputs)
            && angular.equals($scope.Config.outputs, $scope.SavedConfig.outputs));
    };



    $scope.ioPointChanged = function (channelIndex) {
        var output = $scope.Config.outputs[channelIndex];
        if (!output || !output.ioPoint || "" === output.ioPoint) {
            $scope.Config.outputs[channelIndex] = {};
        } else {
            if (!output.ipAddress)
                output.ipAddress = "localhost";
        }
    };
});