/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.JanosLib;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.io.RollingMemoryLog;
import com.integpg.janoslib.system.ApplicationWatchdog;
import com.integpg.janoslib.system.AssemblyBase;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.JANOS;

public class Application {
    private static String _name;
    private static String _version;
    private static String _instanceName;
    private static String _uuid;
    private static String _buildTime;
    private static String _registryRoot;

    public static void init(AssemblyBase assemblyInfo) {
        Application.init(assemblyInfo, null);
    }

    public static void init(AssemblyBase assemblyInfo, String instanceName) {
        _name = assemblyInfo.getName();
        _version = assemblyInfo.getVersion();
        _uuid = assemblyInfo.getUUID();
        _buildTime = assemblyInfo.getBuildTime();
        _instanceName = instanceName;
        _registryRoot = "AppData/" + _name + "/";
        if (null != _instanceName) {
            _registryRoot = _registryRoot + _instanceName + "/";
        }
        JANOS.setRegistryString((String)(_registryRoot + "$Version"), (String)_version);
        JANOS.setRegistryString((String)(_registryRoot + "$JanosLibVersion"), (String)JanosLib.getVersion());
        JANOS.setRegistryString((String)(_registryRoot + "$BuildTime"), (String)_buildTime);
        Application.logBanner();
    }

    public static String getAppName() {
        return _name;
    }

    public static String getAppInstanceName() {
        String name = _name;
        if (null != _instanceName) {
            name = name + "-" + _instanceName;
        }
        return name;
    }

    public static String getAppVersion() {
        return _version;
    }

    public static String getInstanceName() {
        return _instanceName;
    }

    public static String getUuid() {
        return _uuid;
    }

    public static String getRegistryRoot() {
        return _registryRoot;
    }

    private static void logBanner() {
        RollingMemoryLog applicationBootLog = RollingMemoryLog.getLog(Application.getAppName() + "_boot.log", 8192);
        applicationBootLog.setEcho(false);
        String versionString = Application.getAppInstanceName() + " v" + _version;
        AppLog.vital(versionString);
        applicationBootLog.info(versionString);
        if (!_buildTime.equals("")) {
            AppLog.vital(" build-time: " + _buildTime);
            applicationBootLog.info(" build-time: " + _buildTime);
        }
        AppLog.vital(" using Janos Lib v" + JanosLib.getVersion());
        applicationBootLog.info(" Janos Lib: v" + JanosLib.getVersion());
        AppLog.vital(" running on JANOS " + JANOS.getVersion());
        applicationBootLog.info(" JANOS: " + JANOS.getVersion());
        AppLog.vital(" run as as process: " + JANOS.getProcessID());
        JANOS.syslog((String)("-- " + versionString));
        AppLog.vital("Serial Number: " + UnitConfig.SERIAL_NUMBER + ", Model: " + UnitConfig.MODEL);
    }

    public static void enableApplicationWatchdog(int watchdogAction) {
        ApplicationWatchdog applicationWatchdog = new ApplicationWatchdog(watchdogAction);
        applicationWatchdog.start();
    }

    public static void sleepForever() {
        try {
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static void exit(int status) {
        while (AppLog.isBusy()) {
            try {
                System.out.println("AppLog is busy");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.exit(status);
    }

    static {
        _instanceName = null;
        _buildTime = "";
        _registryRoot = "";
    }
}

