/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Helpers.Email;

import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.RegistryListener;
import JniorProtocol.Registry.Registry;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;
import java.util.EventObject;

public class EmailBlock
implements RegistryListener {
    private static final boolean DEBUG = false;
    private static final String REG_FROM_ADDRESS = "Email/BLOCK/FromAddress";
    private static final String REG_TO_ADDRESS = "Email/BLOCK/ToAddress";
    private static final String REG_CC_ADDRESS = "Email/BLOCK/CcAddress";
    private static final String REG_BCC_ADDRESS = "Email/BLOCK/BccAddress";
    private static final String REG_SUBJECT = "Email/BLOCK/Subject";
    private static final String REG_MESSAGE = "Email/BLOCK/Message";
    private static final String REG_MESSAGE_FILE = "Email/BLOCK/MessageFile";
    private static final String REG_HTML_MESSAGE_FILE = "Email/BLOCK/HTMLMessageFile";
    private static final String REG_ATTACHMENTS = "Email/BLOCK/Attachments";
    public static final String DEFAULT_BLOCK = "";
    private JniorSession m_session = null;
    private String blockName;
    private String fromAddress;
    private String toAddress;
    private String ccAddress;
    private String bccAddress;
    private String subject;
    private String message;
    private String messageFile;
    private String htmlMessageFile;
    private String attachments;
    private RegistryRequest request;

    public EmailBlock(JniorSession jniorSession, String string) {
        this.m_session = jniorSession;
        if (string.equalsIgnoreCase("default")) {
            string = DEFAULT_BLOCK;
        }
        this.blockName = string;
    }

    public void set(String string, String string2, String string3) {
        this.toAddress = string;
        this.subject = string2;
        this.message = string3;
    }

    public String getToAddress() {
        return this.toAddress == null ? DEFAULT_BLOCK : this.toAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setFromAddress(String string) {
        this.fromAddress = string;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setCcAddress(String string) {
        this.ccAddress = string;
    }

    public String getCcAddress() {
        return this.ccAddress;
    }

    public void setBccAddress(String string) {
        this.bccAddress = string;
    }

    public String getBccAddress() {
        return this.bccAddress;
    }

    public void setMessageFile(String string) {
        this.messageFile = string;
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public void setHtmlMessageFile(String string) {
        this.htmlMessageFile = string;
    }

    public String getHtmlMessageFile() {
        return this.htmlMessageFile;
    }

    public void setAttachments(String string) {
        this.attachments = string;
    }

    public String getAttachments() {
        return this.attachments;
    }

    public void get() throws CommandTimeoutException, NotYetConnectedException {
        Registry registry = this.m_session.getRegistryInstance();
        this.request = new RegistryRequest();
        if (!this.blockName.equals(DEFAULT_BLOCK)) {
            this.blockName = this.blockName + "/";
        }
        RegistryKey registryKey = registry.getRegKey(REG_TO_ADDRESS.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        registryKey = registry.getRegKey(REG_FROM_ADDRESS.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        registryKey = registry.getRegKey(REG_CC_ADDRESS.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        registryKey = registry.getRegKey(REG_BCC_ADDRESS.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        registryKey = registry.getRegKey(REG_SUBJECT.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        registryKey = registry.getRegKey(REG_MESSAGE.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        registryKey = registry.getRegKey(REG_MESSAGE_FILE.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        registryKey = registry.getRegKey(REG_HTML_MESSAGE_FILE.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        registryKey = registry.getRegKey(REG_ATTACHMENTS.replace("BLOCK/", this.blockName));
        this.request.addKey(registryKey);
        this.request.addRegistryListener(this);
        registry.readRegistry(this.request, false, false);
        while (this.request.getPercentReceived() < 100.0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void clear() throws CommandTimeoutException, NotYetConnectedException, NotLoggedInException {
        Registry registry = this.m_session.getRegistryInstance();
        registry.removeFolder("Email/" + this.blockName);
    }

    public void commit() throws NotYetConnectedException, NotLoggedInException, CommandTimeoutException {
        Registry registry = this.m_session.getRegistryInstance();
        RegistryRequest registryRequest = new RegistryRequest();
        if (this.blockName.equals("<default>")) {
            this.blockName = DEFAULT_BLOCK;
        }
        if (!this.blockName.equals(DEFAULT_BLOCK)) {
            this.blockName = this.blockName + "/";
        }
        this.blockName = this.blockName.replace("//", "/");
        RegistryKey registryKey = registry.getRegKey(REG_TO_ADDRESS.replace("BLOCK/", this.blockName), this.toAddress);
        registryRequest.addKey(registryKey);
        registryKey = registry.getRegKey(REG_FROM_ADDRESS.replace("BLOCK/", this.blockName), this.fromAddress);
        registryRequest.addKey(registryKey);
        registryKey = registry.getRegKey(REG_CC_ADDRESS.replace("BLOCK/", this.blockName), this.ccAddress);
        registryRequest.addKey(registryKey);
        registryKey = registry.getRegKey(REG_BCC_ADDRESS.replace("BLOCK/", this.blockName), this.bccAddress);
        registryRequest.addKey(registryKey);
        registryKey = registry.getRegKey(REG_SUBJECT.replace("BLOCK/", this.blockName), this.subject);
        registryRequest.addKey(registryKey);
        registryKey = registry.getRegKey(REG_MESSAGE.replace("BLOCK/", this.blockName), this.message);
        registryRequest.addKey(registryKey);
        registryKey = registry.getRegKey(REG_MESSAGE_FILE.replace("BLOCK/", this.blockName), this.messageFile);
        registryRequest.addKey(registryKey);
        registryKey = registry.getRegKey(REG_HTML_MESSAGE_FILE.replace("BLOCK/", this.blockName), this.htmlMessageFile);
        registryRequest.addKey(registryKey);
        registryKey = registry.getRegKey(REG_ATTACHMENTS.replace("BLOCK/", this.blockName), this.attachments);
        registryRequest.addKey(registryKey);
        registry.writeRegistry(registryRequest, true);
    }

    public void onRegistryKeyReceived(EventObject eventObject, RegistryKey registryKey) {
        if (registryKey.getKey().indexOf("/ToAddress") > 0) {
            this.toAddress = registryKey.getValue();
        } else if (registryKey.getKey().indexOf("/FromAddress") > 0) {
            this.fromAddress = registryKey.getValue();
        } else if (registryKey.getKey().indexOf("/CcAddress") > 0) {
            this.ccAddress = registryKey.getValue();
        } else if (registryKey.getKey().indexOf("/BccAddress") > 0) {
            this.bccAddress = registryKey.getValue();
        } else if (registryKey.getKey().indexOf("/Subject") > 0) {
            this.subject = registryKey.getValue();
        } else if (registryKey.getKey().indexOf("/MessageFile") > 0) {
            this.messageFile = registryKey.getValue();
        } else if (registryKey.getKey().indexOf("/Message") > 0) {
            this.message = registryKey.getValue();
        } else if (registryKey.getKey().indexOf("/HTMLMessageFile") > 0) {
            this.htmlMessageFile = registryKey.getValue();
        } else if (registryKey.getKey().indexOf("/Attachments") > 0) {
            this.attachments = registryKey.getValue();
        } else {
            Debug.log("Unhandled key = " + registryKey.toString());
        }
    }

    public void onRegistryListReceived(EventObject eventObject, String string, String[] stringArray) {
    }
}

