/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.TaskManager;

import com.integpg.EmbeddedHelpers.Base.EmbeddedBase;
import com.integpg.EmbeddedHelpers.Monitor.IOStateListener;
import com.integpg.EmbeddedHelpers.Monitor.IOStateMonitor;
import com.integpg.EmbeddedHelpers.ThreadWatchdog;
import com.integpg.EmbeddedHelpers.Time.QuickTime;
import com.integpg.TaskManager.ApplicationWatchdog;
import com.integpg.TaskManager.AssemblyInfo;
import com.integpg.TaskManager.Event.Event;
import com.integpg.TaskManager.Event.EventData;
import com.integpg.TaskManager.ExternalModuleFromEventBasedTypeKey;
import com.integpg.TaskManager.LogicalWatcher;
import com.integpg.TaskManager.OneWireMonitor;
import com.integpg.TaskManager.TaskListener;
import com.integpg.TaskManager.Watcher.AnalogWatcher;
import com.integpg.TaskManager.Watcher.Watcher;
import com.integpg.TaskManager.Watcher.WatcherEvent;
import com.integpg.TaskManager.Watcher.WatcherListener;
import com.integpg.TaskManager.externals.ExternalChannelInfo;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class TaskManager
extends EmbeddedBase
implements WatcherListener,
Runnable,
TaskListener,
IOStateListener {
    private static final String APP_NAME = "Task";
    public static final long SECOND_MILLIS = 1000L;
    public static final long MINUTE_MILLIS = 60000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final long DAY_MILLIS = 86400000L;
    private static final String RELOAD_SCHEDULE = "Schedule/$ReloadSchedule";
    public static final String REG_TASK_TIME = "AppData/Task/$Watchdog";
    public static final String REG_TASK_QUIT = "AppData/Task/$Quit";
    private static final int WAIT_TIME = 5;
    private ApplicationWatchdog m_appWatchdog = null;
    private static TaskManager _instance;
    private static String active;
    private EventData[] events = null;
    private Vector watches = new Vector();
    private Vector logicalWatches = new Vector();
    private static long thisCheckTime;
    private static long lastCheckTime;
    private static long lastDayTime;
    private int m_runningTimers = 0;
    public static int[] exts;
    private Thread runner = null;
    private final Vector _currentExecutingTasks = new Vector();

    public TaskManager() {
        super(APP_NAME, AssemblyInfo.getVersion());
        int channel;
        if (this.m_jnioros == null) {
            return;
        }
        if (this.isDuplicateInstance("task.jnior")) {
            this.m_jnioros.syslog("Duplicate Instance, Exiting Now!");
            System.out.println("Duplicate Instance, Exiting Now!");
            return;
        }
        _instance = this;
        for (channel = 0; channel < 12; ++channel) {
            IOStateMonitor.getInstance().addStateListener(this, 0, channel + 1);
        }
        for (channel = 0; channel < 16; ++channel) {
            IOStateMonitor.getInstance().addStateListener(this, 1, channel + 1);
        }
        this.m_appWatchdog = new ApplicationWatchdog(this.m_jnioros, APP_NAME);
        this.m_appWatchdog.start();
        thisCheckTime = QuickTime.getTimeMillis();
        this.loadSchedule();
        this.runSchedule();
        try {
            this.m_jnioros.setRegistryString(REG_TASK_QUIT, "");
            this.m_jnioros.setRegistryString("Schedule/$Active", "");
            this.m_jnioros.setRegistryString("Schedule/$Error", "");
        }
        catch (Exception ex) {
            this.logError("Error setting startup registry keys", ex);
        }
        for (int i = 0; i < this.watches.size(); ++i) {
            ((Watcher)this.watches.elementAt(i)).stop();
        }
        System.out.println("QUITTING!");
        this.m_appWatchdog.triggerWatchdog(0L);
        System.out.println("Task Done");
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ioStateChange(int io, byte channel, byte state, long inputMask, long outputMask) {
        System.out.println("IO Change " + inputMask + " " + outputMask);
        Vector vector = this._currentExecutingTasks;
        synchronized (vector) {
            for (int i = 0; i < this._currentExecutingTasks.size(); ++i) {
                Event event = (Event)this._currentExecutingTasks.elementAt(i);
                event.shouldAbort(inputMask, outputMask);
            }
        }
    }

    public static TaskManager getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskStarted(Event task) {
        Vector vector = this._currentExecutingTasks;
        synchronized (vector) {
            this._currentExecutingTasks.addElement(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskCompleted(Event task) {
        Vector vector = this._currentExecutingTasks;
        synchronized (vector) {
            this._currentExecutingTasks.removeElement(task);
        }
    }

    private void runSchedule() {
        this.runner = new Thread((Runnable)this, "RunSchedule");
        ThreadWatchdog.getInstance().addThread(this.runner);
        System.out.println("Run Schedule");
        this.runApp();
    }

    private void runApp() {
        long lastWatchdog = 0L;
        this.runner.start();
        ++this.m_runningTimers;
        try {
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (InterruptedException ex) {
            this.logError("", ex);
        }
    }

    @Override
    public void stopApp() {
        super.stopApp();
        this.m_quitApp = true;
        ThreadWatchdog.getInstance().stop();
        super.printActiveThreads();
    }

    private void loadSchedule() {
        Object eventInterval = null;
        String prefix = "Schedule/Events";
        try {
            int i;
            int i2;
            System.out.println("Loading Schedule, " + new Date(QuickTime.getTimeMillis()).toString() + "...");
            for (i2 = 0; i2 < this.watches.size(); ++i2) {
                ((Watcher)this.watches.elementAt(i2)).stop();
            }
            this.watches.removeAllElements();
            for (i2 = 0; i2 < this.logicalWatches.size(); ++i2) {
                ((LogicalWatcher)this.logicalWatches.elementAt(i2)).finalize();
            }
            this.logicalWatches.removeAllElements();
            OneWireMonitor.removeAllDevices();
            long[] extid = this.m_jnioros.getExternalDeviceList();
            TaskManager.exts[0] = extid.length > 0 ? this.m_jnioros.getDeviceType(extid[0]) : 0;
            TaskManager.exts[1] = extid.length > 1 ? this.m_jnioros.getDeviceType(extid[1]) : 0;
            active = new String();
            this.m_jnioros.setRegistryString(RELOAD_SCHEDULE, "false");
            String[] eventsList = this.m_jnioros.getRegistryList(prefix);
            int eventsSize = eventsList.length;
            if (this.events == null || eventsSize != this.events.length) {
                this.events = new EventData[eventsSize];
            }
            prefix = prefix + "/";
            ExternalModuleFromEventBasedTypeKey.clearDeviceHash();
            for (i = 0; i < eventsSize; ++i) {
                try {
                    EventData ed;
                    this.events[i] = null;
                    if (!this.m_jnioros.getRegistryBoolean(prefix + eventsList[i] + "Enabled", false) || (ed = TaskManager.loadEvent(prefix + eventsList[i])) == null) continue;
                    if (ed.type.equals("Time")) {
                        this.events[i] = (EventData)ed.clone();
                        continue;
                    }
                    if (ed.type.equals("Event")) {
                        ExternalChannelInfo externalChannelinfo;
                        AnalogWatcher watcher;
                        Watcher w = null;
                        if (ed.eventBasedType.indexOf("Transition") >= 0) {
                            w = new Watcher(3, ed.eventIoNumber, ed.middleNumber, ed);
                        } else if (ed.eventBasedType.indexOf("Counter") >= 0) {
                            w = new Watcher(1, ed.eventIoNumber, ed.middleNumber, ed);
                        } else if (ed.eventBasedType.indexOf("Usage") >= 0) {
                            w = new Watcher(4, ed.eventIoNumber, ed.middleNumber, ed);
                        } else if (ed.eventBasedType.indexOf("AnalogUp") >= 0) {
                            watcher = new AnalogWatcher(ed, 0);
                            externalChannelinfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ed.eventIoNumber);
                            watcher.setExternalChannelInfo(externalChannelinfo);
                            OneWireMonitor.addOneWireDevice(externalChannelinfo.getExternalModuleInfo(), watcher);
                        } else if (ed.eventBasedType.indexOf("AnalogDn") >= 0) {
                            watcher = new AnalogWatcher(ed, 1);
                            externalChannelinfo = ExternalModuleFromEventBasedTypeKey.getExternalModuleFromIoNumber(ed.eventIoNumber);
                            watcher.setExternalChannelInfo(externalChannelinfo);
                            OneWireMonitor.addOneWireDevice(externalChannelinfo.getExternalModuleInfo(), watcher);
                        }
                        if (w == null) continue;
                        w.setWatcherListener(this);
                        this.watches.addElement(w);
                        continue;
                    }
                    if (!ed.type.equals("Logical")) continue;
                    this.logicalWatches.addElement(new LogicalWatcher(ed));
                    continue;
                }
                catch (Exception ex) {
                    this.logError("Error loading event: " + eventsList[i], ex);
                }
            }
            if (active.lastIndexOf(44) >= 0) {
                active = active.substring(0, active.lastIndexOf(44));
            }
            this.m_jnioros.setRegistryString("Schedule/$Active", active);
            for (i = 0; i < this.watches.size(); ++i) {
                ((Watcher)this.watches.elementAt(i)).start();
            }
            OneWireMonitor.monitorOneWireDevices();
        }
        catch (Exception ex) {
            this.logError("Error loading schedule", ex);
        }
        Object eventTime = null;
        Object eventAction = null;
        eventInterval = null;
        prefix = null;
    }

    public static EventData loadEvent(String s) {
        System.out.println("Load Event " + s);
        EventData ed = null;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(QuickTime.getTimeMillis());
        int dayOfWeek = cal.get(7);
        int daysMask = EmbeddedBase.BASE.m_jnioros.getRegistryInt(s + "DaysOfWeek", 0);
        String eventName = EmbeddedBase.BASE.m_jnioros.getRegistryString(s + "Name", "No Entry");
        if (!eventName.equals("No Entry")) {
            ed = new EventData(eventName, "", "");
            if (ed.getData() == null) {
                return null;
            }
            ed.daysMask = daysMask;
            if (ed.endTime < ed.time && ed.endTime != -1L ? !ed.isValidDay(dayOfWeek - 1) : !ed.isValidDay(dayOfWeek)) {
                return null;
            }
        }
        active = active + eventName + ", ";
        try {
            Thread.sleep(5L);
        }
        catch (Exception ex) {
            EmbeddedBase.BASE.logError("", ex);
        }
        eventName = null;
        s = null;
        return ed;
    }

    public static void main(String[] args) {
        if (args != null) {
            for (int argNum = 0; argNum < args.length; ++argNum) {
                if (!args[argNum].equals("-c")) continue;
                String[] files = new File("/www/logs").list();
                System.out.println("Clearing logs.");
                for (int i = 0; i < files.length; ++i) {
                    System.out.println("Deleting " + files[i]);
                    new File("/www/logs/" + files[i]).delete();
                }
            }
        }
        new TaskManager();
    }

    public static long getDayTime() {
        Calendar cal = Calendar.getInstance();
        cal.add(14, (int)thisCheckTime);
        long millis = cal.get(11) * 3600000 + cal.get(12) * 60000 + cal.get(13) * 1000 + cal.get(14);
        return millis;
    }

    @Override
    public void WatcherTriggered(WatcherEvent event) {
        System.out.println("Watcher triggered");
        System.out.println("Event is : " + event);
        if (event != null) {
            System.out.println(event.getEventName());
            int result = 1;
            EventData ed = ((Watcher)event.getSource()).event;
            if (ed._logic != null) {
                try {
                    result = ed._logic.evaluate(this.m_jnioros.getInputStates(), this.m_jnioros.getOutputStates());
                    System.out.println("eval logic: " + result);
                }
                catch (IOException ex) {
                    this.logError("Error evaluating logic: " + ed._logicalExpression, ex);
                }
            }
            if (result == 1) {
                new Event(this).doEvent(ed);
            }
        }
    }

    @Override
    public void run() {
        while (!this.m_quitApp) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                this.logError("", ex);
            }
            try {
                ThreadWatchdog.getInstance().feedWatchdog();
                this.m_appWatchdog.triggerWatchdog(QuickTime.getTimeMillis());
            }
            catch (Exception ex) {
                this.logError("Error feeding watchdog", ex);
            }
            try {
                if (this.m_jnioros.getRegistryBoolean(REG_TASK_QUIT, false)) {
                    this.stopApp();
                    return;
                }
                lastCheckTime = thisCheckTime;
                thisCheckTime = QuickTime.getTimeMillis();
                long dayTime = TaskManager.getDayTime();
                long startOfDay = thisCheckTime - dayTime;
                if (this.m_jnioros.getRegistryBoolean(RELOAD_SCHEDULE, false) || dayTime < lastDayTime) {
                    this.loadSchedule();
                }
                lastDayTime = dayTime;
                boolean eventDone = false;
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(QuickTime.getTimeMillis());
                int dayOfWeek = cal.get(7);
                for (EventData ed : this.events) {
                    if (ed == null) continue;
                    long endTime = ed.endTime;
                    long startTime = ed.time;
                    long triggerTime = ed.recurring ? dayTime - (dayTime - startTime) % ed.interval : ed.time;
                    boolean isValid = false;
                    if (ed.isValidDay(dayOfWeek) && (endTime == -1L || endTime > dayTime) && startTime < dayTime) {
                        isValid = true;
                    }
                    if (!isValid || lastCheckTime - startOfDay >= triggerTime || triggerTime >= thisCheckTime - startOfDay) continue;
                    new Event(this).doEvent(ed);
                    eventDone = true;
                    EmbeddedBase.gc();
                }
                if (!eventDone) continue;
                EmbeddedBase.gc();
            }
            catch (Exception ex) {
                this.logError("Error in run loop", ex);
            }
        }
        this.log("Run loop done?!?");
    }

    @Override
    public void onUserInput(int c) {
    }

    static {
        active = new String();
        lastDayTime = 0L;
        exts = new int[2];
    }
}

