/*
 * Decompiled with CFR 0.152.
 */
package TaskManagerInterface;

import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Helpers.Boolean2;
import JniorProtocol.Helpers.Debug.Debug;
import JniorProtocol.Helpers.Dialogs.LoginDialog;
import JniorProtocol.Helpers.Effects.BlurPane;
import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.ConnectionListener;
import JniorProtocol.Listeners.LoginListener;
import JniorProtocol.Listeners.RegistryListener;
import JniorProtocol.Properties.ConnectionProperties;
import JniorProtocol.Properties.LoginProperties;
import JniorProtocol.Registry.Registry;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;
import TaskManagerInterface.CancelKeyListener;
import TaskManagerInterface.Event.EventData;
import TaskManagerInterface.Event.EventDataFormListener;
import TaskManagerInterface.Event.EventProperties;
import TaskManagerInterface.General.AssemblyInfo;
import TaskManagerInterface.JniorProtocolWrapper;
import TaskManagerInterface.LoginPanel;
import TaskManagerInterface.RunningStatus;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TaskManagerPanel
extends JniorProtocolWrapper
implements EventDataFormListener,
RegistryListener {
    private static final String APP_NAME = "Task";
    private static final String TITLE = "Task Manager";
    private static final String VERSION = AssemblyInfo.getVersion();
    private static final Color INTEG_RED = new Color(216, 30, 5);
    private boolean m_rebooting = false;
    Hashtable eventsHash = new Hashtable();
    DefaultComboBoxModel modelEventNames = new DefaultComboBoxModel();
    EventProperties eventProperties;
    private LoginPanel _loginPanel;
    public DefaultComboBoxModel model_profile = new DefaultComboBoxModel<Object>(new Object[]{"<default>"});
    private Connection m_connection = new Connection();
    private Login m_login = new Login();
    private boolean listClear = false;
    private Object prevSelected;
    private RunningStatus runningStatus = null;
    public boolean closed = false;
    public boolean m_clientCancel = false;
    private Object _listRegistry = new Object();
    private JButton btnCancelChanges;
    private JButton btnSaveChanges;
    private JButton buttonAddEvent;
    private JButton buttonRefreshList;
    private JButton buttonRemoveEvent;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel21;
    private JPanel jPanel25;
    private JPanel jPanel28;
    private JPanel jPanel3;
    private JPanel jPanel34;
    private JPanel jPanel39;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane3;
    public JLabel lblStatus;
    private JLabel lblVersion;
    private JList lvwEvents;
    private JPanel panelSelectEvent;
    private JPanel pnlStatus;
    private JLabel txtActiveEvents;
    private JLabel txtTitle;

    public TaskManagerPanel() {
        this.initComponents();
        this.txtTitle.setForeground(INTEG_RED);
        this.txtActiveEvents.setForeground(INTEG_RED);
        this.eventProperties = new EventProperties(this);
        this.eventProperties.setChangeListener(this);
        this.panelSelectEvent.add((Component)this.eventProperties, "EditEvent");
        this.eventProperties.setVisible(false);
        CardLayout cardLayout = (CardLayout)this.panelSelectEvent.getLayout();
        cardLayout.show(this.panelSelectEvent, "SelectTask");
        this.runningStatus = new RunningStatus(this, APP_NAME);
        this.pnlStatus.add(this.runningStatus);
    }

    private void promptForLogin() {
        this.m_details.setStatusText("Prompting for Login");
        try {
            Window window = SwingUtilities.getWindowAncestor(this);
            LoginDialog loginDialog = null;
            loginDialog = window instanceof Frame ? new LoginDialog((Frame)window, true) : new LoginDialog((Dialog)window, true);
            loginDialog.centerParent();
            loginDialog.setVisible(true);
            loginDialog.setAlwaysOnTop(true);
            if (loginDialog.getResult() == 1) {
                LoginProperties loginProperties = new LoginProperties(loginDialog.getUsername(), loginDialog.getPassword());
                try {
                    this.m_session.login(loginProperties, this.m_login);
                }
                catch (NotYetConnectedException notYetConnectedException) {
                    notYetConnectedException.printStackTrace();
                }
            } else {
                this.m_details.setStatusText("Login Canceled by User");
                this.m_details.setSubStatusText("Click here to Login");
                while (this.m_details.lblSubStatus.getMouseListeners().length > 0) {
                    this.m_details.lblSubStatus.removeMouseListener(this.m_details.lblSubStatus.getMouseListeners()[0]);
                }
                this.m_details.lblSubStatus.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        TaskManagerPanel.this.promptForLogin();
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setConnection(String string, int n) {
        ConnectionProperties connectionProperties = new ConnectionProperties(string, n);
        this.m_session.setConnectionProperties(connectionProperties);
        this.m_session.addConnectionListener(this.m_connection);
    }

    public void setCodebase(String string) {
        this.m_session.setCodebase(string);
    }

    public void startConnection() {
        this.m_details.setStatusText("Connecting...");
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        this.m_blur = new BlurPane(this, this.m_details);
        jRootPane.setGlassPane(this.m_blur);
        this.m_blur.setVisible(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                TaskManagerPanel.this.m_session.setDisplayPackets(false);
                TaskManagerPanel.this.m_session.connect();
            }
        }).start();
    }

    public void close() {
        try {
            this.closed = true;
            Debug.log("Window Closed, Disconnecting.");
            System.out.println(new Date() + " - Window Closed, Disconnecting.\n");
            this.m_session.disconnect();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEmailProfiles() {
        Registry registry = this.m_session.getRegistryInstance();
        String[] stringArray = null;
        try {
            Object object = this._listRegistry;
            synchronized (object) {
                stringArray = registry.listRegistry("Email", true);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].charAt(stringArray[i].length() - 1) != '/') continue;
                    String string = stringArray[i].substring(0, stringArray[i].length() - 1);
                    this.addProfile(string);
                }
            }
        }
        catch (NotYetConnectedException notYetConnectedException) {
            notYetConnectedException.printStackTrace();
        }
        catch (CommandTimeoutException commandTimeoutException) {
            commandTimeoutException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchedule() {
        System.out.println("Requesting Events");
        String[] stringArray = null;
        Object object = this._listRegistry;
        synchronized (object) {
            try {
                stringArray = this.m_session.getRegistryInstance().listRegistry("Schedule/Events", true);
            }
            catch (NotYetConnectedException notYetConnectedException) {
                notYetConnectedException.printStackTrace();
            }
            catch (CommandTimeoutException commandTimeoutException) {
                commandTimeoutException.printStackTrace();
            }
            this.listClear = false;
            Object var3_5 = null;
            if (this.modelEventNames.getSelectedItem() != null) {
                var3_5 = this.lvwEvents.getSelectedValue();
            }
            if (!this.listClear) {
                this.modelEventNames.removeAllElements();
                this.listClear = true;
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addEvent(stringArray[i].replaceAll("/", ""));
                }
                this.lvwEvents.setModel(this.modelEventNames);
            }
            if (var3_5 != null) {
                this.lvwEvents.setSelectedValue(var3_5, true);
            }
        }
    }

    private EventData loadEventData(String string) {
        EventData eventData = (EventData)this.eventsHash.get(string);
        if (eventData == null) {
            eventData = new EventData(this, string);
        }
        eventData.get();
        return eventData;
    }

    private void removeEvent(String string) {
        EventData eventData = (EventData)this.eventsHash.get(string);
        if (eventData == null) {
            return;
        }
        try {
            Registry registry = this.m_session.getRegistryInstance();
            registry.removeFolder("Schedule/Events/" + eventData.name);
            this.eventsHash.remove(eventData.name);
            eventData = null;
        }
        catch (CommandTimeoutException commandTimeoutException) {
            commandTimeoutException.printStackTrace();
        }
        catch (NotLoggedInException notLoggedInException) {
            notLoggedInException.printStackTrace();
        }
        catch (NotYetConnectedException notYetConnectedException) {
            notYetConnectedException.printStackTrace();
        }
    }

    private void addEvent(String string) {
        System.out.println("Add Event " + string);
        EventData eventData = new EventData(this, string);
        this.eventsHash.put(string, eventData);
        this.modelEventNames.addElement(string);
    }

    private void addProfile(String string) {
        boolean bl = false;
        for (int i = 0; i < this.model_profile.getSize(); ++i) {
            if (!this.model_profile.getElementAt(i).toString().equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            this.model_profile.addElement(string);
        }
    }

    private void initComponents() {
        this.jPanel39 = new JPanel();
        this.panelSelectEvent = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel10 = new JPanel();
        this.jPanel28 = new JPanel();
        this.txtTitle = new JLabel();
        this.jPanel21 = new JPanel();
        this.jPanel25 = new JPanel();
        this.jLabel13 = new JLabel();
        this.txtActiveEvents = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel7 = new JPanel();
        this.buttonAddEvent = new JButton();
        this.buttonRemoveEvent = new JButton();
        this.buttonRefreshList = new JButton();
        this.jPanel8 = new JPanel();
        this.btnSaveChanges = new JButton();
        this.btnCancelChanges = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel34 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.lvwEvents = new JList();
        this.pnlStatus = new JPanel();
        this.lblStatus = new JLabel();
        this.lblVersion = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.setLayout(new BorderLayout());
        this.jPanel39.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel39.setLayout(new BorderLayout());
        this.panelSelectEvent.setLayout(new CardLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Please Select a Task");
        this.jPanel1.add((Component)this.jLabel1, "Center");
        this.panelSelectEvent.add((Component)this.jPanel1, "SelectTask");
        this.jPanel39.add((Component)this.panelSelectEvent, "Center");
        this.jPanel10.setLayout(new BorderLayout());
        this.jPanel28.setLayout(new BorderLayout());
        this.txtTitle.setFont(new Font("MS Sans Serif", 0, 18));
        this.txtTitle.setForeground(new Color(216, 30, 5));
        this.txtTitle.setHorizontalAlignment(0);
        this.txtTitle.setText(TITLE);
        this.jPanel28.add((Component)this.txtTitle, "Center");
        this.jPanel21.setBorder(BorderFactory.createEmptyBorder(10, 3, 0, 3));
        this.jPanel21.setLayout(new BoxLayout(this.jPanel21, 1));
        this.jPanel25.setLayout(new BorderLayout());
        this.jLabel13.setText("Todays Tasks: ");
        this.jPanel25.add((Component)this.jLabel13, "West");
        this.jPanel25.add((Component)this.txtActiveEvents, "Center");
        this.jPanel21.add(this.jPanel25);
        this.jPanel28.add((Component)this.jPanel21, "South");
        this.jPanel10.add((Component)this.jPanel28, "Center");
        this.jPanel39.add((Component)this.jPanel10, "North");
        this.jPanel5.setLayout(new BorderLayout());
        this.buttonAddEvent.setBackground(new Color(200, 200, 200));
        this.buttonAddEvent.setText("Add Task");
        this.buttonAddEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskManagerPanel.this.buttonAddEventActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.buttonAddEvent);
        this.buttonRemoveEvent.setBackground(new Color(200, 200, 200));
        this.buttonRemoveEvent.setText("Remove Task");
        this.buttonRemoveEvent.setEnabled(false);
        this.buttonRemoveEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskManagerPanel.this.buttonRemoveEventActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.buttonRemoveEvent);
        this.buttonRefreshList.setBackground(new Color(200, 200, 200));
        this.buttonRefreshList.setText("Refresh Task List");
        this.buttonRefreshList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskManagerPanel.this.buttonRefreshListActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.buttonRefreshList);
        this.jPanel5.add((Component)this.jPanel7, "West");
        this.btnSaveChanges.setBackground(new Color(200, 200, 200));
        this.btnSaveChanges.setText("Save Changes");
        this.btnSaveChanges.setEnabled(false);
        this.btnSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskManagerPanel.this.btnSaveChangesActionPerformed(actionEvent);
            }
        });
        this.jPanel8.add(this.btnSaveChanges);
        this.btnCancelChanges.setBackground(new Color(200, 200, 200));
        this.btnCancelChanges.setText("Cancel Changes");
        this.btnCancelChanges.setEnabled(false);
        this.btnCancelChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskManagerPanel.this.btnCancelChangesActionPerformed(actionEvent);
            }
        });
        this.jPanel8.add(this.btnCancelChanges);
        this.jPanel5.add((Component)this.jPanel8, "East");
        this.jPanel39.add((Component)this.jPanel5, "South");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel34.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Tasks")));
        this.jPanel34.setMaximumSize(new Dimension(178, Integer.MAX_VALUE));
        this.jPanel34.setPreferredSize(new Dimension(170, 166));
        this.jPanel34.setLayout(new BorderLayout());
        this.jScrollPane3.setViewportBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.jScrollPane3.setOpaque(false);
        this.jScrollPane3.setPreferredSize(new Dimension(150, 130));
        this.lvwEvents.setBorder(new SoftBevelBorder(1));
        this.lvwEvents.setSelectionMode(0);
        this.lvwEvents.setMaximumSize(new Dimension(150, 2));
        this.lvwEvents.setMinimumSize(new Dimension(150, 2));
        this.lvwEvents.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TaskManagerPanel.this.lvwEventsValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane3.setViewportView(this.lvwEvents);
        this.jPanel34.add((Component)this.jScrollPane3, "Center");
        this.jPanel3.add((Component)this.jPanel34, "Center");
        this.jPanel39.add((Component)this.jPanel3, "West");
        this.add((Component)this.jPanel39, "Center");
        this.pnlStatus.setPreferredSize(new Dimension(107, 22));
        this.pnlStatus.setLayout(new GridBagLayout());
        this.lblStatus.setText(" ");
        this.lblStatus.setBorder(BorderFactory.createBevelBorder(1));
        this.lblStatus.setMinimumSize(new Dimension(7, 20));
        this.lblStatus.setPreferredSize(new Dimension(7, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlStatus.add((Component)this.lblStatus, gridBagConstraints);
        this.lblVersion.setHorizontalAlignment(0);
        this.lblVersion.setBorder(BorderFactory.createBevelBorder(1));
        this.lblVersion.setMinimumSize(new Dimension(300, 18));
        this.lblVersion.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.pnlStatus.add((Component)this.lblVersion, gridBagConstraints);
        this.add((Component)this.pnlStatus, "South");
    }

    private void buttonRefreshListActionPerformed(ActionEvent actionEvent) {
        this.m_details.setStatusText("Refreshing the Task list");
        this.m_blur.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskManagerPanel.this.loadSchedule();
                TaskManagerPanel.this.m_blur.setVisible(false);
            }
        });
        CardLayout cardLayout = (CardLayout)this.panelSelectEvent.getLayout();
        cardLayout.show(this.panelSelectEvent, "SelectTask");
    }

    private void buttonRemoveEventActionPerformed(ActionEvent actionEvent) {
        Object e = this.lvwEvents.getSelectedValue();
        if (e == null) {
            return;
        }
        final String string = e.toString();
        if (JOptionPane.showConfirmDialog(this, "Are you usure you want to delete the selected event?", "Confirm Delete", 2) == 0) {
            this.m_details.setStatusText("Removing Event");
            this.m_blur.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CardLayout cardLayout = (CardLayout)TaskManagerPanel.this.panelSelectEvent.getLayout();
                    cardLayout.show(TaskManagerPanel.this.panelSelectEvent, "SelectTask");
                    TaskManagerPanel.this.removeEvent(string);
                    int n = TaskManagerPanel.this.lvwEvents.getSelectedIndex();
                    TaskManagerPanel.this.modelEventNames.removeElement(string);
                    TaskManagerPanel.this.lvwEvents.setModel(TaskManagerPanel.this.modelEventNames);
                    TaskManagerPanel.this.loadSchedule();
                    TaskManagerPanel.this.taskReloadSchedule();
                    TaskManagerPanel.this.m_blur.setVisible(false);
                }
            });
        }
    }

    private void btnSaveChangesActionPerformed(ActionEvent actionEvent) {
        this.eventProperties.saveEventData();
    }

    private void taskReloadSchedule() {
        try {
            this.m_session.getRegistryInstance().writeRegistry("Schedule/$ReloadSchedule", "true");
        }
        catch (CommandTimeoutException commandTimeoutException) {
            commandTimeoutException.printStackTrace();
        }
        catch (NotYetConnectedException notYetConnectedException) {
            notYetConnectedException.printStackTrace();
        }
        catch (NotLoggedInException notLoggedInException) {
            notLoggedInException.printStackTrace();
        }
    }

    private void btnCancelChangesActionPerformed(ActionEvent actionEvent) {
        this.eventProperties.displayScheduleData();
    }

    private void lvwEventsValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object e = ((JList)listSelectionEvent.getSource()).getSelectedValue();
        this.buttonRemoveEvent.setEnabled(e != null);
        if (e == null) {
            return;
        }
        final String string = e.toString();
        if (string.equals("")) {
            return;
        }
        CardLayout cardLayout = (CardLayout)this.panelSelectEvent.getLayout();
        cardLayout.show(this.panelSelectEvent, "EditEvent");
        this.m_details.setStatusText("Updating...");
        this.m_blur.setVisible(true);
        final JList jList = (JList)listSelectionEvent.getSource();
        new Thread(new Runnable(){

            @Override
            public void run() {
                TaskManagerPanel.this.loadEventData(string);
                TaskManagerPanel.this.m_blur.setVisible(false);
                if (TaskManagerPanel.this.btnSaveChanges.isEnabled()) {
                    switch (JOptionPane.showConfirmDialog(TaskManagerPanel.this, "Would you like to save the changes you made before continuing?")) {
                        case 0: {
                            TaskManagerPanel.this.eventProperties.saveEventData();
                            break;
                        }
                        case 1: {
                            TaskManagerPanel.this.btnSaveChanges.setEnabled(false);
                            TaskManagerPanel.this.btnCancelChanges.setEnabled(false);
                            break;
                        }
                        case 2: {
                            TaskManagerPanel.this.lvwEvents.setSelectedIndex(jList.getSelectedIndex());
                            return;
                        }
                    }
                }
                if (!TaskManagerPanel.this.btnSaveChanges.isEnabled()) {
                    if (jList.getSelectedIndex() < 0) {
                        return;
                    }
                    TaskManagerPanel.this.eventProperties.displayScheduleData((EventData)TaskManagerPanel.this.eventsHash.get(string));
                }
            }
        }).start();
    }

    private void buttonAddEventActionPerformed(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog(null, (Object)"Enter a name for the event");
        if (string != null) {
            int n = this.lvwEvents.getSelectedIndex();
            this.addEvent(string);
            this.lvwEvents.setModel(this.modelEventNames);
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    final JFrame jFrame = new JFrame("");
                    Container container = jFrame.getContentPane();
                    final JTabbedPane jTabbedPane = new JTabbedPane();
                    container.add(jTabbedPane);
                    final TaskManagerPanel taskManagerPanel = new TaskManagerPanel();
                    jFrame.setSize(750, 625);
                    jFrame.setVisible(true);
                    CancelKeyListener cancelKeyListener = new CancelKeyListener();
                    cancelKeyListener.main = taskManagerPanel;
                    jTabbedPane.addKeyListener(cancelKeyListener);
                    jFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowOpened(WindowEvent windowEvent) {
                            String string = "192.168.1.102";
                            string = "10.0.0.201";
                            if ((string = JOptionPane.showInputDialog(jFrame, "Host Name", string)) != null) {
                                jTabbedPane.addTab(string, taskManagerPanel);
                                taskManagerPanel.setCodebase("http://" + string + "/");
                                taskManagerPanel.setConnection(string, 0);
                                taskManagerPanel.startConnection();
                            }
                        }

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            super.windowClosing(windowEvent);
                            taskManagerPanel.close();
                            jFrame.dispose();
                        }
                    });
                    jTabbedPane.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent mouseEvent) {
                            if (mouseEvent.isPopupTrigger()) {
                                JMenuItem jMenuItem;
                                JPopupMenu jPopupMenu = new JPopupMenu();
                                if (jTabbedPane.getTabCount() > 0) {
                                    jMenuItem = new JMenuItem("Close Tab");
                                    jMenuItem.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent actionEvent) {
                                            TaskManagerPanel taskManagerPanel = (TaskManagerPanel)jTabbedPane.getSelectedComponent();
                                            taskManagerPanel.close();
                                            jTabbedPane.remove(jTabbedPane.getSelectedIndex());
                                        }
                                    });
                                    jPopupMenu.add(jMenuItem);
                                }
                                jMenuItem = new JMenuItem("New Tab");
                                jMenuItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        String string = "";
                                        string = JOptionPane.showInputDialog(jFrame, "IP Address", string);
                                        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                                            if (!jTabbedPane.getTitleAt(i).equals(string)) continue;
                                            return;
                                        }
                                        if (string != null) {
                                            TaskManagerPanel taskManagerPanel = new TaskManagerPanel();
                                            jTabbedPane.addTab(string, taskManagerPanel);
                                            KeyListener[] keyListenerArray = jTabbedPane.getKeyListeners();
                                            for (int i = 0; i < keyListenerArray.length; ++i) {
                                                jTabbedPane.removeKeyListener(keyListenerArray[i]);
                                            }
                                            CancelKeyListener cancelKeyListener = new CancelKeyListener();
                                            cancelKeyListener.main = taskManagerPanel;
                                            jTabbedPane.addKeyListener(cancelKeyListener);
                                            taskManagerPanel.setCodebase("http://" + string + "/");
                                            taskManagerPanel.setConnection(string, 0);
                                            taskManagerPanel.startConnection();
                                        }
                                    }
                                });
                                jPopupMenu.add(jMenuItem);
                                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onChange(EventObject eventObject) {
        this.btnSaveChanges.setEnabled(true);
        this.btnCancelChanges.setEnabled(true);
    }

    @Override
    public void onUndoChanges(EventObject eventObject) {
        this.btnSaveChanges.setEnabled(false);
        this.btnCancelChanges.setEnabled(false);
    }

    @Override
    public void onRegistryKeyReceived(EventObject eventObject, RegistryKey registryKey) {
        if (registryKey.getKey().indexOf("/$Active") > 0) {
            this.txtActiveEvents.setText(registryKey.getValue());
        } else if (registryKey.getKey().indexOf("/Version") > 0) {
            this.lblVersion.setText("vers. jnior " + registryKey.getValue() + " : web " + VERSION);
        }
    }

    @Override
    public void onRegistryListReceived(EventObject eventObject, String string, String[] stringArray) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class Login
    implements LoginListener {
        Login() {
        }

        @Override
        public void onLoginSent(EventObject eventObject, LoginProperties loginProperties) {
            System.out.println(new Date().toString() + " - Login Sent.\n");
            TaskManagerPanel.this.m_details.setSubStatusText("Login Sent...");
        }

        @Override
        public void onLoginSuccess(EventObject eventObject, LoginProperties loginProperties) {
            Object object;
            String string = "Login Success.  Login Level is " + loginProperties.getLoginLevel();
            System.out.println(new Date().toString() + " - " + string);
            TaskManagerPanel.this.m_details.setStatusText(string);
            if (Math.abs(loginProperties.getLoginLevel()) < 128) {
                JOptionPane.showMessageDialog(TaskManagerPanel.this, "Must be Administrator", "Must be Administrator", 0);
                TaskManagerPanel.this.promptForLogin();
            }
            try {
                Registry registry = TaskManagerPanel.this.m_session.getRegistryInstance();
                object = new RegistryRequest();
                registry.writeRegistry((RegistryRequest)object, false);
            }
            catch (NotYetConnectedException notYetConnectedException) {
                notYetConnectedException.printStackTrace();
            }
            catch (NotLoggedInException notLoggedInException) {
                notLoggedInException.printStackTrace();
            }
            catch (CommandTimeoutException commandTimeoutException) {
                commandTimeoutException.printStackTrace();
            }
            int n = Math.abs(loginProperties.getLoginLevel());
            TaskManagerPanel.this.m_details.setStatusText("\nLoading Schedule...");
            TaskManagerPanel.this.m_blur.setVisible(true);
            try {
                object = TaskManagerPanel.this.m_session.getRegistryInstance();
                RegistryRequest registryRequest = new RegistryRequest();
                registryRequest.addKey(((Registry)object).getRegKey("Schedule/$Active"));
                registryRequest.addKey(((Registry)object).getRegKey("AppData/Task/Version"));
                registryRequest.addRegistryListener(TaskManagerPanel.this);
                ((Registry)object).subscribeRegistry(registryRequest);
            }
            catch (CommandTimeoutException commandTimeoutException) {
                commandTimeoutException.printStackTrace();
            }
            catch (NotYetConnectedException notYetConnectedException) {
                notYetConnectedException.printStackTrace();
            }
            TaskManagerPanel.this.loadSchedule();
            TaskManagerPanel.this.m_details.setStatusText("\nRetriving Email Profiles...");
            TaskManagerPanel.this.loadEmailProfiles();
            TaskManagerPanel.this.m_blur.setVisible(false);
        }

        @Override
        public void onLoginFailed(EventObject eventObject, LoginProperties loginProperties) {
            System.out.println(new Date().toString() + " - Login Failed.\n");
            TaskManagerPanel.this.promptForLogin();
        }
    }

    class Connection
    implements ConnectionListener {
        Connection() {
        }

        @Override
        public void onConnectionSuccess(EventObject eventObject, boolean bl) {
            final JniorSession jniorSession = (JniorSession)eventObject.getSource();
            System.out.println(new Date().toString() + " - Connection Successfully Made.\n");
            TaskManagerPanel.this.m_rebooting = false;
            try {
                Registry registry = jniorSession.getRegistryInstance();
                RegistryKey registryKey = registry.getRegKey("Device/AppletDebug", "false");
                registryKey.addRegistryListener(new RegistryListener(){

                    @Override
                    public void onRegistryKeyReceived(EventObject eventObject, RegistryKey registryKey) {
                        boolean bl = Boolean2.parseBoolean(registryKey.getValue());
                        jniorSession.setDisplayPackets(bl);
                    }

                    @Override
                    public void onRegistryListReceived(EventObject eventObject, String string, String[] stringArray) {
                    }
                });
                registry.subscribeRegistry(registryKey);
            }
            catch (CommandTimeoutException commandTimeoutException) {
                commandTimeoutException.printStackTrace();
            }
            catch (NotYetConnectedException notYetConnectedException) {
                notYetConnectedException.printStackTrace();
            }
            int n = -1;
            if (jniorSession.getDirection() == 0) {
                TaskManagerPanel.this.m_details.setStatusText("Retrieving Anonymous Status");
                try {
                    n = TaskManagerPanel.this.m_session.getAnonymousStatus();
                }
                catch (CommandTimeoutException commandTimeoutException) {
                    commandTimeoutException.printStackTrace();
                }
                catch (NotYetConnectedException notYetConnectedException) {
                    notYetConnectedException.printStackTrace();
                }
                System.out.println(new Date().toString() + " - Anonymous level is " + n + ".\n");
            }
            if (jniorSession.getDirection() == 0) {
                try {
                    if (n >= 0) {
                        TaskManagerPanel.this.m_session.login(new LoginProperties("", ""), TaskManagerPanel.this.m_login);
                    } else {
                        try {
                            TaskManagerPanel.this.promptForLogin();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                catch (NotYetConnectedException notYetConnectedException) {
                    notYetConnectedException.printStackTrace();
                }
            }
            TaskManagerPanel.this.runningStatus.monitorWatchdog();
        }

        @Override
        public void onConnectionAttempt(EventObject eventObject, boolean bl) {
            String string = bl ? "Retrying Connection" : "Attempting to connect.";
            System.out.println(new Date().toString() + " - " + string);
            if (!TaskManagerPanel.this.m_rebooting) {
                TaskManagerPanel.this.m_details.setStatusText(string);
            } else {
                TaskManagerPanel.this.m_details.setSubStatusText(string);
            }
        }

        @Override
        public void onConnectionFailed(EventObject eventObject) {
            JniorSession jniorSession = (JniorSession)eventObject.getSource();
            ConnectionProperties connectionProperties = jniorSession.getConnectionProperties();
            String string = "Connection Failed.  " + connectionProperties.getRetriesLeft() + " retries remaining";
            System.out.println(new Date().toString() + " - " + string);
            if (!TaskManagerPanel.this.m_rebooting) {
                TaskManagerPanel.this.m_details.setStatusText(string);
            } else {
                TaskManagerPanel.this.m_details.setSubStatusText(string);
            }
        }

        @Override
        public void onConnectionLost(EventObject eventObject, boolean bl) {
            if (TaskManagerPanel.this.m_clientCancel) {
                Container container = TaskManagerPanel.this.getParent();
                if (container != null) {
                    container.remove(TaskManagerPanel.this);
                }
                TaskManagerPanel.this.m_blur.setVisible(false);
            } else {
                if (TaskManagerPanel.this.closed) {
                    return;
                }
                String string = "Connection Lost.  " + (bl ? "Reconnecting." : "");
                System.out.println(new Date().toString() + " - " + string);
                TaskManagerPanel.this.m_blur.setVisible(true);
                if (!TaskManagerPanel.this.m_rebooting) {
                    TaskManagerPanel.this.m_details.setStatusText(string);
                } else {
                    TaskManagerPanel.this.m_details.setSubStatusText(string);
                }
            }
        }

        @Override
        public void onQueryForPortAttempt(EventObject eventObject) {
            String string = "Querying the JNIOR for the correct port";
            System.out.println(new Date().toString() + " - " + string);
            if (!TaskManagerPanel.this.m_rebooting) {
                TaskManagerPanel.this.m_details.setStatusText(string);
            } else {
                TaskManagerPanel.this.m_details.setSubStatusText(string);
            }
        }

        @Override
        public void onQueryForPortSuccess(EventObject eventObject, int n) {
            String string = "JNIOR Protocol port is port " + n;
            System.out.println(new Date().toString() + " - " + string);
            if (!TaskManagerPanel.this.m_rebooting) {
                TaskManagerPanel.this.m_details.setStatusText(string);
            } else {
                TaskManagerPanel.this.m_details.setSubStatusText(string);
            }
        }
    }
}

