/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Registry;

import JniorProtocol.Listeners.RegistryListener;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequestGroup;
import java.util.Enumeration;
import java.util.Vector;

public class RegistryRequest {
    private static final boolean DEBUG = false;
    private Vector m_registryListeners = new Vector();
    private Vector requestedKeys = new Vector();
    private Vector pendingKeys = new Vector();
    private RegistryRequestGroup parentGroup = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKey(RegistryKey registryKey) {
        Vector vector = this.pendingKeys;
        synchronized (vector) {
            this.requestedKeys.add(registryKey);
            this.pendingKeys.add(registryKey);
            for (int i = 0; i < this.m_registryListeners.size(); ++i) {
                registryKey.addRegistryListener((RegistryListener)this.m_registryListeners.get(i));
            }
        }
    }

    public void addRegistryListener(RegistryListener registryListener) {
        if (registryListener == null) {
            return;
        }
        Enumeration enumeration = this.requestedKeys.elements();
        while (enumeration.hasMoreElements()) {
            RegistryKey registryKey = (RegistryKey)enumeration.nextElement();
            registryKey.addRegistryListener(registryListener);
        }
        for (int i = 0; i < this.m_registryListeners.size(); ++i) {
            if (!((RegistryListener)this.m_registryListeners.elementAt(i)).equals(registryListener)) continue;
            return;
        }
        this.m_registryListeners.add(registryListener);
    }

    public RegistryKey[] getAllKeys() {
        Object[] objectArray = this.requestedKeys.toArray();
        RegistryKey[] registryKeyArray = new RegistryKey[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            registryKeyArray[i] = (RegistryKey)objectArray[i];
        }
        return registryKeyArray;
    }

    public int getCountRequested() {
        return this.requestedKeys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountRemaining() {
        Vector vector = this.pendingKeys;
        synchronized (vector) {
            for (int i = 0; i < this.pendingKeys.size(); ++i) {
                RegistryKey registryKey = (RegistryKey)this.pendingKeys.get(i);
                if (registryKey.getPending()) continue;
                this.pendingKeys.remove(registryKey);
            }
        }
        return this.pendingKeys.size();
    }

    public int getCountReceived() {
        return this.getCountRequested() - this.getCountRemaining();
    }

    public double getPercentReceived() {
        int n = this.getCountReceived();
        if (n == 0) {
            return 0.0;
        }
        return (double)n / (double)this.getCountRequested() * 100.0;
    }

    void setGroup(RegistryRequestGroup registryRequestGroup) {
        this.parentGroup = registryRequestGroup;
    }
}

