/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.tasker.ConfigurationFileMonitor;
import com.integ.tasker.FileModifiedEvent;
import com.integ.tasker.FileModifiedListener;
import com.integ.tasker.WorkspaceConfigurationFile;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class WorkspaceDirectory
implements FileModifiedListener {
    private static final Hashtable<String, WorkspaceConfigurationFile> CONFIGURATION_FILES = new Hashtable();
    private static final Hashtable<String, Long> LAST_MODIFIED_TIME_BY_FILENAME = new Hashtable();
    private static boolean InitialLoad = true;
    private final File _workspacesDirectory;

    public WorkspaceDirectory(File workspacesDirectory) {
        this._workspacesDirectory = workspacesDirectory;
    }

    public static boolean IsInitialLoad() {
        return InitialLoad;
    }

    public void monitorWorkspaceDirectory() {
        AppLog.info("monitor workspace directory");
        ConfigurationFileMonitor.addFile(this._workspacesDirectory, this);
    }

    @Override
    public boolean fileModified(FileModifiedEvent fileModifiedEvent) {
        this.loadWorkspaceFiles();
        return true;
    }

    private void loadWorkspaceFiles() {
        String[] workspaceFileStrings;
        Object KnownConfigFiles = CONFIGURATION_FILES.clone();
        System.out.println("load workspace files");
        for (String workspaceFilename : workspaceFileStrings = this._workspacesDirectory.list()) {
            if (!workspaceFilename.endsWith(".json")) continue;
            String fullPathName = this._workspacesDirectory.getPath() + workspaceFilename;
            File file = new File(fullPathName);
            if (((Hashtable)KnownConfigFiles).containsKey(fullPathName)) {
                ((Hashtable)KnownConfigFiles).remove(fullPathName);
            }
            WorkspaceConfigurationFile configurationFile = null;
            if (!CONFIGURATION_FILES.containsKey(fullPathName)) {
                System.out.println("new workspace file: " + fullPathName);
                configurationFile = new WorkspaceConfigurationFile(file);
                CONFIGURATION_FILES.put(fullPathName, configurationFile);
                configurationFile.load();
            } else {
                long lastModifiedTime = LAST_MODIFIED_TIME_BY_FILENAME.get(fullPathName);
                if (file.lastModified() != lastModifiedTime) {
                    AppLog.info(file.getPath() + " has been modified at " + QuickDateFormat.getDefault().format(file.lastModified()));
                    configurationFile = CONFIGURATION_FILES.get(fullPathName);
                    configurationFile.reload();
                }
            }
            LAST_MODIFIED_TIME_BY_FILENAME.put(fullPathName, file.lastModified());
        }
        if (0 < ((Hashtable)KnownConfigFiles).size()) {
            Enumeration e = ((Hashtable)KnownConfigFiles).keys();
            while (e.hasMoreElements()) {
                String fullPath = (String)e.nextElement();
                AppLog.info(fullPath + " has been removed");
                WorkspaceConfigurationFile configurationFile = (WorkspaceConfigurationFile)((Hashtable)KnownConfigFiles).get(fullPath);
                configurationFile.stop();
            }
        }
        InitialLoad = false;
    }
}

