/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Helpers.Slaving;

import JniorProtocol.Exceptions.CommandTimeoutException;
import JniorProtocol.Exceptions.NotLoggedInException;
import JniorProtocol.Exceptions.NotYetConnectedException;
import JniorProtocol.Exceptions.RequiresRebootException;
import JniorProtocol.JniorSession;
import JniorProtocol.Registry.Registry;
import JniorProtocol.Registry.RegistryKey;
import JniorProtocol.Registry.RegistryRequest;

public class Slaving {
    private static final String REG_SLAVING = "IO/Outputs/rout#/Slave";
    public static final String LOCALHOST = "localhost";
    public static final String DIN1 = "din1";
    public static final String DIN2 = "din2";
    public static final String DIN3 = "din3";
    public static final String DIN4 = "din4";
    public static final String DIN5 = "din5";
    public static final String DIN6 = "din6";
    public static final String DIN7 = "din7";
    public static final String DIN8 = "din8";
    public static final String ROUT1 = "rout1";
    public static final String ROUT2 = "rout2";
    public static final String ROUT3 = "rout3";
    public static final String ROUT4 = "rout4";
    public static final String ROUT5 = "rout5";
    public static final String ROUT6 = "rout6";
    public static final String ROUT7 = "rout7";
    public static final String ROUT8 = "rout8";
    private JniorSession m_session = null;
    private int localChannel;
    private String host = null;
    private int port;
    private String username = null;
    private String password = null;
    private String remoteIoPoint = null;

    public Slaving() {
    }

    public Slaving(JniorSession jniorSession) {
        this.m_session = jniorSession;
    }

    public void set(int n, String string) {
        this.localChannel = n;
        this.remoteIoPoint = string;
        this.host = null;
    }

    public void set(int n, String string, int n2, String string2, String string3, String string4) {
        this.localChannel = n;
        this.remoteIoPoint = string4;
        this.host = string;
        this.port = n2;
        this.username = string2;
        this.password = string3;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRemoteIoPoint() {
        return this.remoteIoPoint;
    }

    public void get(int n) throws CommandTimeoutException, NotYetConnectedException {
        Registry registry = this.m_session.getRegistryInstance();
        String string = REG_SLAVING.replace("#", Integer.toString(n));
        String string2 = registry.readRegistry(string, "");
        this.parse(string2);
    }

    public void clear(int n) throws NotYetConnectedException, NotLoggedInException, CommandTimeoutException, RequiresRebootException {
        Registry registry = this.m_session.getRegistryInstance();
        String string = REG_SLAVING.replace("#", Integer.toString(n));
        String string2 = "";
        RegistryRequest registryRequest = new RegistryRequest();
        RegistryKey registryKey = registry.getRegKey(string);
        registryKey.setValue(string2);
        registryRequest.addKey(registryKey);
        registry.writeRegistry(registryRequest, true);
        throw new RequiresRebootException();
    }

    public void commit() throws NotYetConnectedException, NotLoggedInException, CommandTimeoutException, RequiresRebootException {
        Registry registry = this.m_session.getRegistryInstance();
        String string = REG_SLAVING.replace("#", Integer.toString(this.localChannel));
        String string2 = "";
        if (this.host != null) {
            string2 = string2 + this.host + ", " + this.port + ", " + this.username + ", " + this.password + ", ";
        } else if (!this.remoteIoPoint.equals("")) {
            string2 = string2 + "localhost, , , , ";
        }
        if (!string2.equals("") && !this.remoteIoPoint.equals("")) {
            string2 = string2 + this.remoteIoPoint;
        }
        RegistryRequest registryRequest = new RegistryRequest();
        RegistryKey registryKey = registry.getRegKey(string, string2);
        registryRequest.addKey(registryKey);
        registry.writeRegistry(registryRequest, true);
        this.parse(string2);
        throw new RequiresRebootException();
    }

    public void parse(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length >= 4) {
            if (!stringArray[0].trim().equals("")) {
                this.host = stringArray[0].trim();
            }
            if (!stringArray[1].trim().equals("")) {
                this.port = Integer.parseInt(stringArray[1].trim());
            }
            if (!stringArray[2].trim().equals("")) {
                this.username = stringArray[2].trim();
            }
            if (!stringArray[3].trim().equals("")) {
                this.password = stringArray[3].trim();
            }
            if (stringArray.length >= 5 && !stringArray[4].trim().equals("")) {
                this.remoteIoPoint = stringArray[4].trim();
            }
        }
    }
}

