/*
 * Decompiled with CFR 0.152.
 */
package TaskManagerInterface.Event;

import TaskManagerInterface.TaskManagerPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ActionDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private TaskManagerPanel main;
    private String newAction;
    private ButtonGroup buttonGroupAction;
    private ButtonGroup buttonGroupIO;
    private ButtonGroup buttonGroupMain;
    private JButton cancelButton;
    private JPanel cardLevel2;
    private JCheckBox chkAlarmStates;
    private JCheckBox chkChannel1;
    private JCheckBox chkChannel10;
    private JCheckBox chkChannel11;
    private JCheckBox chkChannel12;
    private JCheckBox chkChannel13;
    private JCheckBox chkChannel14;
    private JCheckBox chkChannel15;
    private JCheckBox chkChannel16;
    private JCheckBox chkChannel2;
    private JCheckBox chkChannel3;
    private JCheckBox chkChannel4;
    private JCheckBox chkChannel5;
    private JCheckBox chkChannel6;
    private JCheckBox chkChannel7;
    private JCheckBox chkChannel8;
    private JCheckBox chkChannel9;
    private JCheckBox chkCounters;
    private JCheckBox chkLatches;
    private JCheckBox chkMask;
    private JCheckBox chkStates;
    private JCheckBox chkUsageMeters;
    private JComboBox cmbEmail;
    private JComboBox combDeviceSelect;
    private JComboBox combIOSelect;
    private JComboBox combLocationSelect;
    private JCheckBox delayChk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel2;
    private JPanel jPanel27;
    private JPanel jPanel3;
    private JPanel jPanel31;
    private JPanel jPanel32;
    private JPanel jPanel33;
    private JPanel jPanel38;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane2;
    private JButton okButton;
    private JPanel panelAction;
    private JPanel panelEmail;
    private JPanel panelIOselect;
    private JPanel panelReset;
    private JPanel pnlActionProperties;
    private JPanel pnlActionType;
    private JPanel pnlAnalog;
    private JPanel pnlButtons;
    private JPanel pnlContent;
    private JPanel pnlIo;
    private JPanel pnlIoNorth;
    private JPanel pnlLog;
    private JPanel pnlOther;
    private JPanel pnlSelectTypeTitle;
    private JPanel pnlTypes;
    private JRadioButton rbAction;
    private JRadioButton rbAnalog;
    private JRadioButton rbClose;
    private JRadioButton rbDin;
    private JRadioButton rbEmail;
    private JRadioButton rbLog;
    private JRadioButton rbOpen;
    private JRadioButton rbOther;
    private JRadioButton rbPulseHi;
    private JRadioButton rbPulseLo;
    private JRadioButton rbReset;
    private JRadioButton rbRout;
    private JRadioButton rbToggle;
    private JTextField txtChannelNumber;
    private JTextField txtDelay;
    private JTextField txtFileMaxSize;
    private JTextField txtFileName;
    private JTextArea txtFormat;
    private JTextArea txtLogHelp;
    private JTextField txtOtherAction;
    private JTextField txtPulseTime;
    private JTextField txtValue;
    private int returnStatus = 0;

    public ActionDialog(Frame frame, boolean bl, TaskManagerPanel taskManagerPanel) {
        super(frame, bl);
        this.initComponents();
        this.main = taskManagerPanel;
        this.txtLogHelp.setText("%timestamp% - Time stamp.\r\n%milliseconds% - Milliseconds since 1/1/1970 GMT.\r\nBelow, x represents an integer in the range 1 - 8.\r\n%dinx% - Digital input state of x.\r\n%routx% - Relay output state of x. Note that x can also be in the range 9 - 16.\r\n%cinx% - Counter value of x.\r\n%uinx% - Input usage meter time of x.\r\n%uoutx% - Output usage meter time of x.\r\n%extidx% - Analog value for device d channel x.\r\nWhere i is either i (in) or o (out), and d is one of a (4-20mA), r (RTD), t (Temp.), or v (10V).\r\nAnything else between %s is assumed to be a registry key.\r\nAnything not inbetween % is static text that will appear as is.");
        this.cmbEmail.setModel(taskManagerPanel.model_profile);
        this.chkMask.setVisible(false);
        this.txtChannelNumber.setVisible(false);
    }

    public void centerParent() {
        Container container = this.getParent();
        Point point = container.getLocationOnScreen();
        Dimension dimension = container.getSize();
        Dimension dimension2 = this.getSize();
        int n = dimension.width > dimension2.width ? (dimension.width - dimension2.width) / 2 + point.x : point.x;
        int n2 = dimension.height > dimension2.height ? (dimension.height - dimension2.height) / 2 + point.y : point.y;
        this.setLocation(n, n2);
        this.requestFocus();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public String getAction() {
        return this.newAction;
    }

    public void loadAction(String string) {
        String string2 = string;
        string = string.toLowerCase();
        String string3 = string.substring(0, 3);
        System.out.println(string3);
        int n = 0;
        this.chkMask.setVisible(false);
        this.txtChannelNumber.setVisible(false);
        this.chkMask.setSelected(string.indexOf("mask") >= 0);
        this.rbDin.setSelected(string.indexOf("din") >= 0);
        this.rbDin.setEnabled(true);
        this.rbRout.setSelected(string.indexOf("rout") >= 0);
        if (string3.compareTo("res") == 0) {
            this.rbReset.doClick();
        } else if (string3.compareTo("ana") == 0) {
            this.rbAnalog.doClick();
        } else if (string3.compareTo("log") == 0) {
            this.rbLog.doClick();
        } else if (string3.compareTo("ema") == 0) {
            this.rbEmail.doClick();
        } else if (string3.compareTo("oth") == 0) {
            this.rbOther.doClick();
        } else {
            this.rbAction.doClick();
        }
        this.rbToggle.setSelected(string.indexOf("toggle") >= 0);
        this.rbOpen.setSelected(string.indexOf("open") >= 0);
        this.rbClose.setSelected(string.indexOf("close") >= 0);
        this.rbPulseHi.setSelected(string.indexOf("pulsehi") >= 0);
        this.rbPulseLo.setSelected(string.indexOf("pulselo") >= 0);
        this.txtPulseTime.setText("");
        this.txtFileName.setText("");
        this.txtChannelNumber.setText("");
        this.chkStates.setSelected(false);
        this.chkCounters.setSelected(false);
        this.chkUsageMeters.setSelected(false);
        int n2 = 50;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        String string4 = null;
        while (stringTokenizer.hasMoreTokens() && n2-- > 0) {
            String string5 = stringTokenizer.nextToken().trim().toLowerCase();
            if (string5.equals("-time")) {
                this.txtPulseTime.setText(stringTokenizer.nextToken());
                continue;
            }
            if (string5.equals("-file")) {
                this.txtFileName.setText(stringTokenizer.nextToken());
                continue;
            }
            if (string5.equals("-profile")) {
                this.cmbEmail.setSelectedItem(stringTokenizer.nextToken());
                continue;
            }
            if (string5.equals("-max")) {
                this.txtFileMaxSize.setText(stringTokenizer.nextToken());
                continue;
            }
            if (string5.equals("-opts")) {
                String string6 = stringTokenizer.nextToken();
                this.chkStates.setSelected(string6.indexOf("states") >= 0);
                this.chkCounters.setSelected(string6.indexOf("counters") >= 0);
                this.chkUsageMeters.setSelected(string6.indexOf("usage") >= 0);
                continue;
            }
            if (string5.equals("-format")) {
                string4 = stringTokenizer.nextToken();
                this.txtFormat.setText(string4);
                continue;
            }
            if (string5.equals("-dev")) {
                String string7 = stringTokenizer.nextToken();
                if (string7.indexOf("mA") >= 0) {
                    this.combDeviceSelect.setSelectedIndex(1);
                    continue;
                }
                this.combDeviceSelect.setSelectedIndex(0);
                continue;
            }
            if (string5.equals("-chan")) {
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                if (n3 >= 4) {
                    this.combLocationSelect.setSelectedIndex(1);
                    n3 -= 4;
                } else {
                    this.combLocationSelect.setSelectedIndex(0);
                }
                this.combIOSelect.setSelectedIndex(n3);
                continue;
            }
            if (string5.equals("-val")) {
                double d = Long.parseLong(stringTokenizer.nextToken());
                this.txtValue.setText(Double.toString(d /= 1000.0));
                continue;
            }
            if (string5.equals("-delay")) {
                this.delayChk.setSelected(true);
                this.txtDelay.setText(stringTokenizer.nextToken());
                continue;
            }
            if (string5.equals("din") || string5.equals("rout")) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                this.txtChannelNumber.setText(String.valueOf(n));
                continue;
            }
            if (string5.equals("-action")) {
                StringBuilder stringBuilder = new StringBuilder();
                while (stringTokenizer.hasMoreTokens() && n2-- > 0) {
                    if (0 < stringBuilder.length()) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(stringTokenizer.nextToken());
                }
                this.txtOtherAction.setText(stringBuilder.toString());
                break;
            }
            if (string4 == null) continue;
            string4 = string4 + string5;
            this.txtFormat.setText(string4);
        }
        this.chkChannel1.setSelected(n & true);
        this.chkChannel2.setSelected((n & 2) != 0);
        this.chkChannel3.setSelected((n & 4) != 0);
        this.chkChannel4.setSelected((n & 8) != 0);
        this.chkChannel5.setSelected((n & 0x10) != 0);
        this.chkChannel6.setSelected((n & 0x20) != 0);
        this.chkChannel7.setSelected((n & 0x40) != 0);
        this.chkChannel8.setSelected((n & 0x80) != 0);
        this.chkChannel9.setSelected((n & 0x100) != 0);
        this.chkChannel10.setSelected((n & 0x200) != 0);
        this.chkChannel11.setSelected((n & 0x400) != 0);
        this.chkChannel12.setSelected((n & 0x800) != 0);
        this.chkChannel13.setSelected((n & 0x1000) != 0);
        this.chkChannel14.setSelected((n & 0x2000) != 0);
        this.chkChannel15.setSelected((n & 0x4000) != 0);
        this.chkChannel16.setSelected((n & 0x8000) != 0);
    }

    private void initComponents() {
        this.buttonGroupAction = new ButtonGroup();
        this.buttonGroupMain = new ButtonGroup();
        this.buttonGroupIO = new ButtonGroup();
        this.pnlContent = new JPanel();
        this.pnlActionType = new JPanel();
        this.pnlSelectTypeTitle = new JPanel();
        this.jLabel1 = new JLabel();
        this.pnlTypes = new JPanel();
        this.rbAction = new JRadioButton();
        this.rbAnalog = new JRadioButton();
        this.rbReset = new JRadioButton();
        this.rbEmail = new JRadioButton();
        this.rbLog = new JRadioButton();
        this.rbOther = new JRadioButton();
        this.pnlActionProperties = new JPanel();
        this.pnlIo = new JPanel();
        this.pnlIoNorth = new JPanel();
        this.cardLevel2 = new JPanel();
        this.panelAction = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.rbToggle = new JRadioButton();
        this.rbClose = new JRadioButton();
        this.rbOpen = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.rbPulseLo = new JRadioButton();
        this.rbPulseHi = new JRadioButton();
        this.jPanel16 = new JPanel();
        this.jLabel12 = new JLabel();
        this.txtPulseTime = new JTextField();
        this.panelReset = new JPanel();
        this.chkStates = new JCheckBox();
        this.chkCounters = new JCheckBox();
        this.chkUsageMeters = new JCheckBox();
        this.chkAlarmStates = new JCheckBox();
        this.chkLatches = new JCheckBox();
        this.panelIOselect = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel15 = new JPanel();
        this.chkMask = new JCheckBox();
        this.rbDin = new JRadioButton();
        this.rbRout = new JRadioButton();
        this.txtChannelNumber = new JTextField();
        this.jPanel27 = new JPanel();
        this.chkChannel1 = new JCheckBox();
        this.chkChannel2 = new JCheckBox();
        this.chkChannel3 = new JCheckBox();
        this.chkChannel4 = new JCheckBox();
        this.chkChannel5 = new JCheckBox();
        this.chkChannel6 = new JCheckBox();
        this.chkChannel7 = new JCheckBox();
        this.chkChannel8 = new JCheckBox();
        this.chkChannel9 = new JCheckBox();
        this.chkChannel10 = new JCheckBox();
        this.chkChannel11 = new JCheckBox();
        this.chkChannel12 = new JCheckBox();
        this.chkChannel13 = new JCheckBox();
        this.chkChannel14 = new JCheckBox();
        this.chkChannel15 = new JCheckBox();
        this.chkChannel16 = new JCheckBox();
        this.pnlLog = new JPanel();
        this.jPanel17 = new JPanel();
        this.jPanel31 = new JPanel();
        this.jLabel10 = new JLabel();
        this.txtFileName = new JTextField();
        this.jPanel32 = new JPanel();
        this.jLabel15 = new JLabel();
        this.txtFileMaxSize = new JTextField();
        this.jPanel33 = new JPanel();
        this.jLabel16 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.txtFormat = new JTextArea();
        this.txtLogHelp = new JTextArea();
        this.panelEmail = new JPanel();
        this.jPanel38 = new JPanel();
        this.jLabel21 = new JLabel();
        this.cmbEmail = new JComboBox();
        this.pnlAnalog = new JPanel();
        this.jLabel13 = new JLabel();
        this.combDeviceSelect = new JComboBox();
        this.jLabel14 = new JLabel();
        this.combIOSelect = new JComboBox();
        this.jLabel17 = new JLabel();
        this.combLocationSelect = new JComboBox();
        this.jLabel4 = new JLabel();
        this.txtValue = new JTextField();
        this.pnlOther = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel5 = new JLabel();
        this.txtOtherAction = new JTextField();
        this.jPanel5 = new JPanel();
        this.delayChk = new JCheckBox();
        this.jLabel18 = new JLabel();
        this.txtDelay = new JTextField();
        this.pnlButtons = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ActionDialog.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.pnlContent.setBorder(BorderFactory.createEtchedBorder());
        this.pnlContent.setLayout(new BorderLayout());
        this.pnlActionType.setLayout(new BoxLayout(this.pnlActionType, 1));
        this.pnlSelectTypeTitle.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Select the Type of Action");
        this.pnlSelectTypeTitle.add(this.jLabel1);
        this.pnlActionType.add(this.pnlSelectTypeTitle);
        this.pnlTypes.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.pnlTypes.setLayout(new FlowLayout(0));
        this.buttonGroupMain.add(this.rbAction);
        this.rbAction.setText("Digital Control");
        this.rbAction.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbActionItemStateChanged(itemEvent);
            }
        });
        this.rbAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionDialog.this.rbActionActionPerformed(actionEvent);
            }
        });
        this.pnlTypes.add(this.rbAction);
        this.buttonGroupMain.add(this.rbAnalog);
        this.rbAnalog.setText("Analog Control");
        this.rbAnalog.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbAnalog.setMargin(new Insets(0, 0, 0, 0));
        this.rbAnalog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbAnalogItemStateChanged(itemEvent);
            }
        });
        this.pnlTypes.add(this.rbAnalog);
        this.buttonGroupMain.add(this.rbReset);
        this.rbReset.setText("Reset");
        this.rbReset.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbResetItemStateChanged(itemEvent);
            }
        });
        this.pnlTypes.add(this.rbReset);
        this.buttonGroupMain.add(this.rbEmail);
        this.rbEmail.setText("Email");
        this.rbEmail.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbEmailItemStateChanged(itemEvent);
            }
        });
        this.pnlTypes.add(this.rbEmail);
        this.buttonGroupMain.add(this.rbLog);
        this.rbLog.setText("Log");
        this.rbLog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbLogItemStateChanged(itemEvent);
            }
        });
        this.rbLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionDialog.this.rbLogActionPerformed(actionEvent);
            }
        });
        this.pnlTypes.add(this.rbLog);
        this.buttonGroupMain.add(this.rbOther);
        this.rbOther.setText("Other");
        this.rbOther.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbOtherItemStateChanged(itemEvent);
            }
        });
        this.pnlTypes.add(this.rbOther);
        this.pnlActionType.add(this.pnlTypes);
        this.pnlContent.add((Component)this.pnlActionType, "North");
        this.pnlActionProperties.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.pnlActionProperties.setLayout(new CardLayout());
        this.pnlIo.setLayout(new BorderLayout());
        this.pnlIoNorth.setLayout(new BoxLayout(this.pnlIoNorth, 1));
        this.cardLevel2.setLayout(new CardLayout());
        this.panelAction.setLayout(new BoxLayout(this.panelAction, 1));
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jLabel2.setText("Select the Type of Control");
        this.jPanel2.add(this.jLabel2);
        this.panelAction.add(this.jPanel2);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.buttonGroupAction.add(this.rbToggle);
        this.rbToggle.setText("Toggle");
        this.rbToggle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbToggleItemStateChanged(itemEvent);
            }
        });
        this.jPanel1.add(this.rbToggle);
        this.buttonGroupAction.add(this.rbClose);
        this.rbClose.setText("Close");
        this.rbClose.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbCloseItemStateChanged(itemEvent);
            }
        });
        this.jPanel1.add(this.rbClose);
        this.buttonGroupAction.add(this.rbOpen);
        this.rbOpen.setText("Open");
        this.rbOpen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.actionSelected(itemEvent);
            }
        });
        this.jPanel1.add(this.rbOpen);
        this.panelAction.add(this.jPanel1);
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jPanel3.setLayout(new FlowLayout(0));
        this.buttonGroupAction.add(this.rbPulseLo);
        this.rbPulseLo.setText("Pulse Lo");
        this.rbPulseLo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.pulseSelected(itemEvent);
            }
        });
        this.jPanel3.add(this.rbPulseLo);
        this.buttonGroupAction.add(this.rbPulseHi);
        this.rbPulseHi.setText("Pulse Hi");
        this.rbPulseHi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.pulseSelected(itemEvent);
            }
        });
        this.jPanel3.add(this.rbPulseHi);
        this.jPanel16.setPreferredSize(new Dimension(250, 30));
        this.jPanel16.setLayout(new FlowLayout(0));
        this.jLabel12.setText("Pulse Time (ms)");
        this.jPanel16.add(this.jLabel12);
        this.txtPulseTime.setEnabled(false);
        this.txtPulseTime.setMinimumSize(new Dimension(50, 19));
        this.txtPulseTime.setPreferredSize(new Dimension(50, 19));
        this.jPanel16.add(this.txtPulseTime);
        this.jPanel3.add(this.jPanel16);
        this.panelAction.add(this.jPanel3);
        this.cardLevel2.add((Component)this.panelAction, "Action");
        this.panelReset.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.panelReset.setLayout(new FlowLayout(0));
        this.chkStates.setText("States");
        this.chkStates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.chkStatesItemStateChanged(itemEvent);
            }
        });
        this.panelReset.add(this.chkStates);
        this.chkCounters.setText("Counters");
        this.chkCounters.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.chkCountersItemStateChanged(itemEvent);
            }
        });
        this.panelReset.add(this.chkCounters);
        this.chkUsageMeters.setText("Usage Meters");
        this.chkUsageMeters.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.chkUsageMetersItemStateChanged(itemEvent);
            }
        });
        this.panelReset.add(this.chkUsageMeters);
        this.chkAlarmStates.setText("Alarm States");
        this.chkAlarmStates.setEnabled(false);
        this.panelReset.add(this.chkAlarmStates);
        this.chkLatches.setText("Latches");
        this.chkLatches.setEnabled(false);
        this.panelReset.add(this.chkLatches);
        this.cardLevel2.add((Component)this.panelReset, "Reset");
        this.pnlIoNorth.add(this.cardLevel2);
        this.panelIOselect.setLayout(new BoxLayout(this.panelIOselect, 1));
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel3.setText("Select the I/O");
        this.jPanel4.add(this.jLabel3);
        this.panelIOselect.add(this.jPanel4);
        this.jPanel15.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jPanel15.setLayout(new FlowLayout(0));
        this.chkMask.setText("Mask");
        this.jPanel15.add(this.chkMask);
        this.buttonGroupIO.add(this.rbDin);
        this.rbDin.setText("DIN");
        this.rbDin.setEnabled(false);
        this.jPanel15.add(this.rbDin);
        this.buttonGroupIO.add(this.rbRout);
        this.rbRout.setText("ROUT");
        this.rbRout.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.rbRoutItemStateChanged(itemEvent);
            }
        });
        this.rbRout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionDialog.this.rbRoutActionPerformed(actionEvent);
            }
        });
        this.jPanel15.add(this.rbRout);
        this.txtChannelNumber.setMinimumSize(new Dimension(50, 21));
        this.txtChannelNumber.setPreferredSize(new Dimension(50, 21));
        this.jPanel15.add(this.txtChannelNumber);
        this.panelIOselect.add(this.jPanel15);
        this.jPanel27.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.jPanel27.setLayout(new GridLayout(0, 8));
        this.chkChannel1.setText("1");
        this.chkChannel1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel1);
        this.chkChannel2.setText("2");
        this.chkChannel2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel2);
        this.chkChannel3.setText("3");
        this.chkChannel3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel3);
        this.chkChannel4.setText("4");
        this.chkChannel4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel4);
        this.chkChannel5.setText("5");
        this.chkChannel5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel5);
        this.chkChannel6.setText("6");
        this.chkChannel6.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel6);
        this.chkChannel7.setText("7");
        this.chkChannel7.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel7);
        this.chkChannel8.setText("8");
        this.chkChannel8.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel8);
        this.chkChannel9.setText("9");
        this.chkChannel9.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel9);
        this.chkChannel10.setText("10");
        this.chkChannel10.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel10);
        this.chkChannel11.setText("11");
        this.chkChannel11.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel11);
        this.chkChannel12.setText("12");
        this.chkChannel12.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel12);
        this.chkChannel13.setText("13");
        this.chkChannel13.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel13);
        this.chkChannel14.setText("14");
        this.chkChannel14.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel14);
        this.chkChannel15.setText("15");
        this.chkChannel15.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel15);
        this.chkChannel16.setText("16");
        this.chkChannel16.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ActionDialog.this.channelSelected(itemEvent);
            }
        });
        this.jPanel27.add(this.chkChannel16);
        this.panelIOselect.add(this.jPanel27);
        this.pnlIoNorth.add(this.panelIOselect);
        this.pnlIo.add((Component)this.pnlIoNorth, "North");
        this.pnlActionProperties.add((Component)this.pnlIo, "ActionReset");
        this.pnlLog.setLayout(new BoxLayout(this.pnlLog, 1));
        this.jPanel17.setLayout(new BoxLayout(this.jPanel17, 2));
        this.jLabel10.setText("Log File Name");
        this.jPanel31.add(this.jLabel10);
        this.txtFileName.setEnabled(false);
        this.txtFileName.setMinimumSize(new Dimension(150, 19));
        this.txtFileName.setPreferredSize(new Dimension(150, 21));
        this.jPanel31.add(this.txtFileName);
        this.jPanel17.add(this.jPanel31);
        this.jLabel15.setText("Log File Max Size (KB)   ");
        this.jPanel32.add(this.jLabel15);
        this.txtFileMaxSize.setEnabled(false);
        this.txtFileMaxSize.setMinimumSize(new Dimension(100, 19));
        this.txtFileMaxSize.setPreferredSize(new Dimension(100, 21));
        this.jPanel32.add(this.txtFileMaxSize);
        this.jPanel17.add(this.jPanel32);
        this.pnlLog.add(this.jPanel17);
        this.jPanel33.setLayout(new BorderLayout());
        this.jLabel16.setText("  Format (place a comma between fields, no spaces)");
        this.jPanel33.add((Component)this.jLabel16, "North");
        this.txtFormat.setLineWrap(true);
        this.txtFormat.setPreferredSize(new Dimension(0, 50));
        this.jScrollPane2.setViewportView(this.txtFormat);
        this.jPanel33.add((Component)this.jScrollPane2, "Center");
        this.txtLogHelp.setEditable(false);
        this.txtLogHelp.setLineWrap(true);
        this.txtLogHelp.setMinimumSize(new Dimension(300, 22));
        this.txtLogHelp.setOpaque(false);
        this.txtLogHelp.setPreferredSize(new Dimension(400, 200));
        this.jPanel33.add((Component)this.txtLogHelp, "Last");
        this.pnlLog.add(this.jPanel33);
        this.pnlActionProperties.add((Component)this.pnlLog, "Logger");
        this.panelEmail.setLayout(new BorderLayout());
        this.jLabel21.setText("Email Profile");
        this.jPanel38.add(this.jLabel21);
        this.cmbEmail.setPreferredSize(new Dimension(110, 22));
        this.jPanel38.add(this.cmbEmail);
        this.panelEmail.add((Component)this.jPanel38, "North");
        this.pnlActionProperties.add((Component)this.panelEmail, "Email");
        this.pnlAnalog.setLayout(new GridBagLayout());
        this.jLabel13.setText("Device:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.pnlAnalog.add((Component)this.jLabel13, gridBagConstraints);
        this.combDeviceSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Ext. 10V Analog Module", "Ext. 4-20mA Analog Module"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.pnlAnalog.add((Component)this.combDeviceSelect, gridBagConstraints);
        this.jLabel14.setText("I/O:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.pnlAnalog.add((Component)this.jLabel14, gridBagConstraints);
        this.combIOSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"Analog Out 1", "Analog Out 2"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlAnalog.add((Component)this.combIOSelect, gridBagConstraints);
        this.jLabel17.setText("Location:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlAnalog.add((Component)this.jLabel17, gridBagConstraints);
        this.combLocationSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"External 1", "External 2"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pnlAnalog.add((Component)this.combLocationSelect, gridBagConstraints);
        this.jLabel4.setText("Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 250, 0);
        this.pnlAnalog.add((Component)this.jLabel4, gridBagConstraints);
        this.txtValue.setColumns(10);
        this.txtValue.setMinimumSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 41;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 250, 0);
        this.pnlAnalog.add((Component)this.txtValue, gridBagConstraints);
        this.pnlActionProperties.add((Component)this.pnlAnalog, "Analog");
        this.pnlOther.setLayout(new BoxLayout(this.pnlOther, 2));
        this.jLabel5.setText("Action:");
        this.jPanel6.add(this.jLabel5);
        this.txtOtherAction.setPreferredSize(new Dimension(300, 20));
        this.jPanel6.add(this.txtOtherAction);
        this.pnlOther.add(this.jPanel6);
        this.pnlActionProperties.add((Component)this.pnlOther, "Other");
        this.pnlContent.add((Component)this.pnlActionProperties, "Center");
        this.getContentPane().add(this.pnlContent);
        this.delayChk.setText("Delayed Execution");
        this.delayChk.setActionCommand("delayChk");
        this.delayChk.setHorizontalAlignment(11);
        this.delayChk.setHorizontalTextPosition(10);
        this.jPanel5.add(this.delayChk);
        this.jLabel18.setText("Delay Time (sec): ");
        this.jPanel5.add(this.jLabel18);
        this.txtDelay.setMinimumSize(new Dimension(50, 20));
        this.txtDelay.setPreferredSize(new Dimension(50, 20));
        this.jPanel5.add(this.txtDelay);
        this.getContentPane().add(this.jPanel5);
        this.pnlButtons.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.pnlButtons.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.pnlButtons.add(this.cancelButton);
        this.getContentPane().add(this.pnlButtons);
        this.pack();
    }

    private void rbAnalogItemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.cardLevel2.getLayout();
        cardLayout.show(this.cardLevel2, "Action");
        cardLayout = (CardLayout)this.pnlActionProperties.getLayout();
        cardLayout.show(this.pnlActionProperties, "Analog");
    }

    private void rbToggleItemStateChanged(ItemEvent itemEvent) {
        this.rbAction.setSelected(true);
    }

    private void rbCloseItemStateChanged(ItemEvent itemEvent) {
        this.rbAction.setSelected(true);
    }

    private void enableRbDin() {
        this.rbDin.setEnabled(this.rbReset.isSelected());
    }

    private void enableRbRout() {
        this.rbRout.setEnabled(!this.chkCounters.isSelected());
        boolean bl = !this.rbReset.isSelected() && !this.chkCounters.isSelected() && !this.chkUsageMeters.isSelected() && this.rbRout.isSelected();
        this.chkChannel9.setEnabled(bl);
        this.chkChannel10.setEnabled(bl);
        this.chkChannel11.setEnabled(bl);
        this.chkChannel12.setEnabled(bl);
        this.chkChannel13.setEnabled(bl);
        this.chkChannel14.setEnabled(bl);
        this.chkChannel15.setEnabled(bl);
        this.chkChannel16.setEnabled(bl);
        if (!bl) {
            this.chkChannel9.setSelected(false);
            this.chkChannel10.setSelected(false);
            this.chkChannel11.setSelected(false);
            this.chkChannel12.setSelected(false);
            this.chkChannel13.setSelected(false);
            this.chkChannel14.setSelected(false);
            this.chkChannel15.setSelected(false);
            this.chkChannel16.setSelected(false);
        }
    }

    private void chkUsageMetersItemStateChanged(ItemEvent itemEvent) {
        this.enableRbDin();
        this.enableRbRout();
    }

    private void chkCountersItemStateChanged(ItemEvent itemEvent) {
        this.enableRbDin();
        this.enableRbRout();
    }

    private void chkStatesItemStateChanged(ItemEvent itemEvent) {
        this.enableRbDin();
        this.enableRbRout();
    }

    private void rbRoutActionPerformed(ActionEvent actionEvent) {
    }

    /*
     * Unable to fully structure code
     */
    private boolean saveAction() {
        var2_1 = new String();
        var3_2 = new String();
        try {
            if (this.buttonGroupMain.getSelection() == null) {
                throw new Exception("Please select a main catagory for the action");
            }
            if (this.rbAction.isSelected()) {
                var2_1 = var2_1 + this.getChannelString();
                if (this.buttonGroupAction.getSelection() == null) {
                    throw new Exception("Please select an action to preform");
                }
                var1_3 = this.buttonGroupAction.getElements();
                while (var1_3.hasMoreElements()) {
                    var4_4 = (JRadioButton)var1_3.nextElement();
                    if (!var4_4.isSelected() || var4_4 == this.rbAction) continue;
                    var3_2 = var3_2 + var4_4.getText().toLowerCase().replaceAll(" ", "") + " ";
                }
                try {
                    if (!this.rbPulseHi.isSelected() && !this.rbPulseLo.isSelected()) ** GOTO lbl81
                    var3_2 = var3_2 + "-time " + Integer.parseInt(this.txtPulseTime.getText()) + " ";
                }
                catch (Exception var4_5) {
                    throw new Exception("Please enter a value for the Pulse Duration");
                }
            } else if (this.rbReset.isSelected()) {
                var2_1 = var2_1 + this.getChannelString();
                var3_2 = var3_2 + "reset -opts ";
                if (this.chkStates.isSelected() && this.chkStates.isEnabled()) {
                    var3_2 = var3_2 + "states;";
                }
                if (this.chkCounters.isSelected()) {
                    var3_2 = var3_2 + "counters;";
                }
                if (this.chkUsageMeters.isSelected()) {
                    var3_2 = var3_2 + "usage;";
                }
                if (this.chkAlarmStates.isSelected()) {
                    var3_2 = var3_2 + "alarms;";
                }
                if (this.chkLatches.isSelected()) {
                    var3_2 = var3_2 + "latches;";
                }
                if (var3_2.charAt(var3_2.length() - 1) == ';') {
                    var3_2 = var3_2.substring(0, var3_2.length() - 1) + " ";
                }
            } else if (this.rbLog.isSelected()) {
                if (this.txtFileName.getText().equals("")) {
                    throw new Exception("Please enter a file name for the log");
                }
                if (this.txtFormat.getText().equals("")) {
                    throw new Exception("Please enter a file format");
                }
                var3_2 = var3_2 + "log -file ";
                var3_2 = var3_2 + this.txtFileName.getText();
                if (!this.txtFileMaxSize.getText().equals("")) {
                    var3_2 = var3_2 + " -max ";
                    var3_2 = var3_2 + this.txtFileMaxSize.getText();
                }
                if (this.txtFormat.getText().indexOf(59) >= 0) {
                    throw new Exception("Spaces and semicolons are not permitted in the file format.");
                }
                if (this.txtFormat.getText().indexOf(32) >= 0) {
                    throw new Exception("Spaces and semicolons are not permitted in the file format.");
                }
                if ((var3_2 = var3_2 + " -format " + this.txtFormat.getText()).charAt(var3_2.length() - 1) == ';') {
                    var3_2 = var3_2.substring(0, var3_2.length() - 1) + " ";
                }
            } else if (this.rbOther.isSelected()) {
                var3_2 = var3_2 + "other -action ";
                var3_2 = var3_2 + this.txtOtherAction.getText();
            } else if (this.rbEmail.isSelected()) {
                if (this.cmbEmail.getSelectedIndex() < 0) {
                    throw new Exception("Please select a valid email profile");
                }
                var3_2 = var3_2 + "email -profile ";
                var3_2 = var3_2 + this.cmbEmail.getSelectedItem();
            } else if (this.rbAnalog.isSelected()) {
                try {
                    Double.parseDouble(this.txtValue.getText());
                }
                catch (NumberFormatException var4_6) {
                    throw new Exception("Please enter a valid analog value to set.");
                }
                var3_2 = var3_2 + "analog -dev ";
                var3_2 = this.combDeviceSelect.getSelectedIndex() == 0 ? var3_2 + "V" : var3_2 + "mA";
                var3_2 = var3_2 + " -chan ";
                var4_7 = this.combIOSelect.getSelectedIndex();
                if (this.combLocationSelect.getSelectedIndex() == 1) {
                    var4_7 += 4;
                }
                var3_2 = var3_2 + Integer.toString(var4_7);
                var5_10 = Double.parseDouble(this.txtValue.getText());
                var3_2 = var3_2 + " -val " + Long.toString((long)(var5_10 *= 1000.0));
            }
lbl81:
            // 9 sources

            var3_2 = var3_2 + var2_1;
            if (this.delayChk.isSelected()) {
                if (this.txtDelay.getText().equals("")) {
                    throw new Exception("Please enter a valid delay time");
                }
                var4_8 = Integer.parseInt(this.txtDelay.getText());
                if (var4_8 < 1) {
                    throw new Exception("Please enter a valid delay time (>= 1 second)");
                }
                var3_2 = var3_2 + " -delay " + this.txtDelay.getText();
            }
            this.newAction = var3_2;
        }
        catch (Exception var4_9) {
            JOptionPane.showMessageDialog(this, var4_9.getMessage());
            return false;
        }
        return true;
    }

    private void rbRoutItemStateChanged(ItemEvent itemEvent) {
        if ((this.rbReset.isSelected() || this.rbLog.isSelected()) && this.rbRout.isSelected()) {
            this.chkCounters.setEnabled(false);
        } else {
            this.chkCounters.setEnabled(true);
        }
    }

    private void channelSelected(ItemEvent itemEvent) {
        int n = 0;
        if (this.chkChannel1.isSelected()) {
            ++n;
        }
        if (this.chkChannel2.isSelected()) {
            n += 2;
        }
        if (this.chkChannel3.isSelected()) {
            n += 4;
        }
        if (this.chkChannel4.isSelected()) {
            n += 8;
        }
        if (this.chkChannel5.isSelected()) {
            n += 16;
        }
        if (this.chkChannel6.isSelected()) {
            n += 32;
        }
        if (this.chkChannel7.isSelected()) {
            n += 64;
        }
        if (this.chkChannel8.isSelected()) {
            n += 128;
        }
        if (this.chkChannel9.isSelected()) {
            n += 256;
        }
        if (this.chkChannel10.isSelected()) {
            n += 512;
        }
        if (this.chkChannel11.isSelected()) {
            n += 1024;
        }
        if (this.chkChannel12.isSelected()) {
            n += 2048;
        }
        if (this.chkChannel13.isSelected()) {
            n += 4096;
        }
        if (this.chkChannel14.isSelected()) {
            n += 8192;
        }
        if (this.chkChannel15.isSelected()) {
            n += 16384;
        }
        if (this.chkChannel16.isSelected()) {
            n += 32768;
        }
        this.txtChannelNumber.setText(String.valueOf(n));
        this.chkMask.setSelected(true);
    }

    private void actionSelected(ItemEvent itemEvent) {
        this.rbAction.setSelected(true);
    }

    private void pulseSelected(ItemEvent itemEvent) {
        this.rbAction.setSelected(true);
        this.txtPulseTime.setEnabled(((JRadioButton)itemEvent.getSource()).isSelected());
    }

    private void rbResetItemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.cardLevel2.getLayout();
        cardLayout.show(this.cardLevel2, "Reset");
        cardLayout = (CardLayout)this.pnlActionProperties.getLayout();
        cardLayout.show(this.pnlActionProperties, "ActionReset");
        this.chkStates.setEnabled(!this.rbReset.isSelected());
        if (this.rbReset.isSelected() && this.rbRout.isSelected()) {
            this.chkCounters.setEnabled(false);
        } else {
            this.chkCounters.setEnabled(true);
        }
    }

    private void rbActionItemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.cardLevel2.getLayout();
        cardLayout.show(this.cardLevel2, "Action");
        cardLayout = (CardLayout)this.pnlActionProperties.getLayout();
        cardLayout.show(this.pnlActionProperties, "ActionReset");
        this.rbDin.setEnabled(!this.rbAction.isSelected());
        this.rbRout.setSelected(this.rbAction.isSelected());
        this.chkCounters.setSelected(false);
        this.enableRbRout();
    }

    private void rbEmailItemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.cardLevel2.getLayout();
        cardLayout.show(this.cardLevel2, "Action");
        cardLayout = (CardLayout)this.pnlActionProperties.getLayout();
        cardLayout.show(this.pnlActionProperties, "Email");
    }

    private void rbLogItemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.pnlActionProperties.getLayout();
        cardLayout.show(this.pnlActionProperties, "Logger");
        this.txtFileName.setEnabled(this.rbLog.isSelected());
        this.txtFileMaxSize.setEnabled(this.rbLog.isSelected());
        if (this.rbLog.isSelected() && this.rbRout.isSelected()) {
            this.chkCounters.setEnabled(false);
        } else {
            this.chkCounters.setEnabled(true);
        }
    }

    private String getChannelString() throws Exception {
        String string = new String();
        if (this.buttonGroupIO.getSelection() == null) {
            throw new Exception("Neither DIN or ROUT are selected");
        }
        if (this.txtChannelNumber.getText().equals("") || Integer.parseInt(this.txtChannelNumber.getText()) < 0 || Integer.parseInt(this.txtChannelNumber.getText()) > 65535) {
            throw new Exception("Invalid channel number");
        }
        if (!this.chkMask.isSelected() && Integer.parseInt(this.txtChannelNumber.getText()) > 8) {
            throw new Exception("Mask is not selected and the channel number exceeds the channels on the JNIOR");
        }
        if (this.chkMask.isSelected()) {
            string = string + "-mask ";
        }
        string = this.rbDin.isSelected() ? string + "din " : string + "rout ";
        string = string + String.valueOf(this.txtChannelNumber.getText());
        return string;
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.saveAction()) {
            this.doClose(1);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void rbActionActionPerformed(ActionEvent actionEvent) {
    }

    private void rbLogActionPerformed(ActionEvent actionEvent) {
    }

    private void rbOtherItemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.pnlActionProperties.getLayout();
        cardLayout.show(this.pnlActionProperties, "Other");
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ActionDialog((Frame)new JFrame(), true, null).setVisible(true);
            }
        });
    }
}

