/*
 * Decompiled with CFR 0.152.
 */
package JniorProtocol.Registry;

import JniorProtocol.JniorSession;
import JniorProtocol.Listeners.RegistryListener;
import java.util.EventObject;
import java.util.Vector;

public abstract class RegistryKey
implements Comparable {
    protected JniorSession m_session;
    protected short uid;
    protected String key;
    protected String value;
    protected String defaultValue;
    protected boolean subscribed = false;
    protected Vector m_registryListeners = new Vector();
    protected boolean pending = false;

    public short getUid() {
        return this.uid;
    }

    public int getInputChannelNumber() {
        int n = -1;
        int n2 = this.getKey().indexOf("Inputs/din");
        if (n2 >= 0) {
            int n3 = this.getKey().indexOf("/", n2 += 10);
            n = Integer.parseInt(this.getKey().substring(n2, n3));
        }
        return n;
    }

    public int getOutputChannelNumber() {
        int n = -1;
        int n2 = this.getKey().indexOf("Outputs/rout");
        if (n2 >= 0) {
            int n3 = this.getKey().indexOf("/", n2 += 12);
            n = Integer.parseInt(this.getKey().substring(n2, n3));
        }
        return n;
    }

    public void incrementUid() {
        this.uid = (short)(this.uid + 1);
    }

    public String getKey() {
        return this.key;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setValue(String string) {
        if (string.equals("") && this.defaultValue != null) {
            string = this.defaultValue;
        }
        this.value = string;
        this.fireRegistryReceivedEvent();
    }

    public String getValue() {
        return this.value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setSubscribed(boolean bl) {
        this.subscribed = bl;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setPending() {
        this.pending = true;
    }

    public void clearPending() {
        this.pending = false;
    }

    public boolean getPending() {
        return this.pending;
    }

    public void addRegistryListener(RegistryListener registryListener) {
        if (registryListener == null) {
            return;
        }
        for (int i = 0; i < this.m_registryListeners.size(); ++i) {
            if (!((RegistryListener)this.m_registryListeners.elementAt(i)).equals(registryListener)) continue;
            return;
        }
        this.m_registryListeners.add(registryListener);
    }

    public Vector getListeners() {
        return this.m_registryListeners;
    }

    public void fireRegistryReceivedEvent() {
        if (this.m_registryListeners == null) {
            return;
        }
        int n = 0;
        while (n < this.m_registryListeners.size()) {
            final int n2 = n++;
            new Thread(new Runnable(){

                public void run() {
                    ((RegistryListener)RegistryKey.this.m_registryListeners.elementAt(n2)).onRegistryKeyReceived(new EventObject(RegistryKey.this.m_session), RegistryKey.this);
                }
            }).start();
        }
    }

    protected static short getUniqueId(String string) {
        int n = 5381;
        for (int i = 0; i < string.length(); ++i) {
            n = (n << 5) + n + string.charAt(i);
        }
        return (short)n;
    }

    public String toString() {
        return "(" + this.uid + ") - " + this.key + " = " + this.value;
    }

    public int compareTo(Object object) {
        RegistryKey registryKey = (RegistryKey)object;
        if (registryKey.getValue() == this.value) {
            return 0;
        }
        return -1;
    }
}

