/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.controlstructures;

import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import java.util.Json;

public class IfElseMethod
extends Action {
    private final String _conditional;
    private final Action[] _actions;
    private final Action[] _elseActions;

    public IfElseMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._conditional = this._paramsJson.getString("Conditional");
        System.out.println("conditional: " + this._conditional);
        this._actions = super.getActions("Actions");
        System.out.println("if " + this._actions.length + " actions");
        this._elseActions = super.getActions("ElseActions");
        System.out.println("else " + this._actions.length + " actions");
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        long start = System.currentTimeMillis();
        boolean _debug_ = taskRuntime.Scope.isDebug();
        try {
            ExpressionEngine _expressionEngine = new ExpressionEngine();
            _expressionEngine.setDebug(_debug_);
            _expressionEngine.parse(this._conditional);
            Object resultObject = _expressionEngine.execute(taskRuntime.Scope);
            System.out.println("resultObject = " + resultObject);
            if (((Boolean)resultObject).booleanValue()) {
                for (Action action : this._actions) {
                    action.execute(taskRuntime);
                }
            } else {
                for (Action action : this._elseActions) {
                    action.execute(taskRuntime);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing If Conditional: " + this._conditional).initCause(ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("if then elapsed: " + elapsed);
    }
}

